//
// Copyright (C) 1996  Lars Berntzon
//
// Description:
//	Main control class for xsadb applikation.
//
extern "C" {
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Command.h>
}

#include <sadblib.hh>
#include <iostream.h>
#include <xsadb.hh>
#include <XSADB.hh>
#include <DBPanel.hh>
#include <DBList.hh>


XSADB::XSADB(Widget aTopShell) :
	panelList(0),
	createObject(aTopShell),
	topshell(0),
	top(0),
	dbFrame(0),
	buttonsFrame(0)
{

    topshell = aTopShell;

    if (getenv("SAHOME") == 0 && getenv("SADBDIR") == 0) {
    	cerr << "xsadb: either SAHOME or SADBDIR must be set\n";
    	exit(1);
    }

    top = XtCreateManagedWidget(
			  "toplevel",			// Name.
			  boxWidgetClass,		// Widget class.
			  topshell,			// Parent.
			  NULL,				// Arguments.
			  0);				// Number of arguments.

    create_menus(top);

    XtCreateManagedWidget(
			  "title",			// Name.
			  labelWidgetClass,		// Widget class.
			  top,				// Parent.
			  NULL,				// Arguments.
			  0);				// Number of arguments.

    //
    // Create a frame around a frame of database buttons.
    // This frame is the used for creating new frames for buttons.
    //
    dbFrame = XtCreateManagedWidget(
			      "dbFrame",		// Name.
			      boxWidgetClass,		// Widget class.
			      top,			// Parent.
			      NULL,			// Arguments.
			      0);			// Number of arguments.
    update();

    //
    // Make the database creation panel.
    //
    //createObject.setup(topshell);
    createObject.registerUpdateable(this);

    return;
}

XSADB::~XSADB()
{
    if (panelList) {
	delete [] panelList;
    }
}

void
XSADB::update(void)
{
    TextList columns;
    int isRealized = XtIsRealized(dbFrame);
    char buf[MAXNAME];
    Pix p;
    int i;

    if (isRealized) XtUnrealizeWidget(dbFrame);

    if (buttonsFrame) XtDestroyWidget(buttonsFrame);
    buttonsFrame = 0;

    //
    // Examine which databases there are.
    //
    columns = SADB::list_databases();
    if (columns.empty()) {
    	cerr << "xsadb: there are no databases\n";
    	return;
    }

    //
    // Create list of panels and names to pass as argument
    // in X callbacks.
    //
    if (panelList != 0) {
    	delete [] panelList;
    }
    panelList = new DBPanel[columns.length()];

    //
    // Create frame for buttons.
    //
    buttonsFrame = XtCreateManagedWidget(
			  "buttonsFrame",		// Name.
			  boxWidgetClass,		// Widget class.
			  dbFrame,			// Parent.
			  NULL,				// Arguments.
			  0);				// Number of arguments.

    //
    // Create buttons for all databases and store a open database
    // in the dbList array.
    //
    for(i = 0, p = columns.first(); p != 0; i++, columns.next(p))
    {
	//
	// Create the database button.
	//
	sprintf(buf, "db_%s", columns(p).name());
	Widget command = XtVaCreateManagedWidget(
			      buf,			// Name.
			      commandWidgetClass,	// Widget class.
			      buttonsFrame,		// Parent.
			      XtNlabel,			// Arguments.
			      columns(p).name(),
			      NULL);
	XtAddCallback(command,
		      XtNcallback,
		      hdl_x11_database_choice,
		      (char *)(panelList + i));

	//
	// Make an entry in the dbList array and open that database.
	//
	dbList[columns(p).name()].open(columns(p).name());

    	//
    	// Initalize the panel.
    	//
    	new (panelList + i) DBPanel(topshell, columns(p).name());
    }
    
    XtManageChild(dbFrame);
    if (isRealized) XtRealizeWidget(dbFrame);
}

void
XSADB::create_file_menu(Widget toplevel)
{

    Widget fileMenu = XtVaCreatePopupShell(
    			      "fileMenu", 
    			      simpleMenuWidgetClass,
    			      toplevel,
    			      NULL);

    Widget createDatabase = XtVaCreateManagedWidget(
    			      "createDatabase",
    			      smeBSBObjectClass,
    			      fileMenu,
    			      NULL);
    XtAddCallback(createDatabase,
    		  XtNcallback,
    		  hdl_x11_create_database,
    	          (XtPointer *)this);

    Widget quit = XtVaCreateManagedWidget(
    			      "quit",
    			      smeBSBObjectClass,
    			      fileMenu,
    			      NULL);

    XtAddCallback(quit, XtNcallback, hdl_x11_done, NULL);

    XtVaCreateManagedWidget(
			      "fileMenuButton",		// Name.
			      menuButtonWidgetClass,	// Widget class.
			      toplevel,			// Parent.
			      XtNmenuName,		// Arguments.
			      "fileMenu",
			      NULL);
}

void
XSADB::create_database(void)
{
    createObject.popup();
}

void
XSADB::create_database_menu(Widget toplevel)
{

    Widget fileMenu = XtVaCreatePopupShell(
    			      "databaseMenu", 
    			      simpleMenuWidgetClass,
    			      toplevel,
    			      NULL);

    XtVaCreateManagedWidget(
    			      "open",
    			      smeBSBObjectClass,
    			      fileMenu,
    			      NULL);

    XtVaCreateManagedWidget(
    			      "save",
    			      smeBSBObjectClass,
    			      fileMenu,
    			      NULL);

    XtVaCreateManagedWidget(
			      "databaseMenuButton",	// Name.
			      menuButtonWidgetClass,	// Widget class.
			      toplevel,			// Parent.
			      XtNmenuName,		// Arguments.
			      "databaseMenu",
			      NULL);
}

void
XSADB::create_menus(Widget toplevel)
{
    Widget menuBar = XtCreateManagedWidget(
                              "menuBar",                // Name.
                              boxWidgetClass,           // Widget class.
                              toplevel,                 // Parent.
                              NULL,                     // Arguments.
                              0);                       // Number of arguments.

    create_file_menu(menuBar);
}

//
// X11 Callback routines
//
void
XSADB::hdl_x11_database_choice(Widget w, XtPointer appData, XtPointer callData)
{
    DBPanel *panel = (DBPanel *)appData;

    panel->popup();
}

void
XSADB::hdl_x11_create_database(Widget w, XtPointer appData, XtPointer callData)
{
    ((XSADB *)appData)->create_database();
}

void
XSADB::hdl_x11_done(Widget w, XtPointer appData, XtPointer callData)
{
    exit(0);
}

//
// History of changes:
// $Log: XSADB.cc,v $
// Revision 1.4  1996/09/14 18:33:44  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.3  1996/03/21 18:57:59  lasse
// Backup
//
// Revision 1.2  1996/03/12 19:43:22  lasse
// Checking in from remote.
//
// Revision 1.17  1996/01/22  20:17:23  lasse
// Checking in from mobile
//
// Revision 1.16  1995/11/09  21:21:04  lasse
// To be 0.9
//
// Revision 1.15  1995/10/22  12:33:04  lasse
// backup
//
// Revision 1.14  1995/10/22  11:57:57  lasse
// Now search and update works
//
// Revision 1.13  1995/10/16  22:51:47  lasse
// bckup
//
// Revision 1.12  1995/10/16  22:11:31  lasse
// backup
//
// Revision 1.11  1995/09/26  20:38:18  lasse
// backup
//
// Revision 1.10  1995/09/24  22:02:07  lasse
// backup
//
// Revision 1.9  1995/09/23  13:46:15  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:12  qdtlarb
// THis is version 0.6
//
// Revision 1.8  1995/09/10  20:43:28  lasse
// Added copyright everywhere
//
// Revision 1.7  1995/09/10  19:03:46  lasse
// Corrected removed Log keyword
//
