//
// Copyright (C) 1996  Lars Berntzon
//
#ifndef XSADB_HH
#define XSADB_HH

extern "C" {
#include <X11/Intrinsic.h>
}

#include <DBCreate.hh>
#include <Updateable.hh>

class DBPanel;

class XSADB : public Updateable
{
public:
    XSADB(Widget topshell);
    virtual void update(void);
    virtual ~XSADB();

private:
    DBPanel *panelList;
    DBCreate createObject;
    Widget topshell;
    Widget top;
    Widget dbFrame;
    Widget buttonsFrame;

    void create_menus(Widget w);
    void create_database_menu(Widget toplevel);
    void create_file_menu(Widget toplevel);
    void create_database(void);
    void hdl_database_choice(const char *dbName);
  
    //
    // X11 callback routines.
    //
    static void hdl_x11_database_choice(Widget w, XtPointer appData, XtPointer callData);
    static void hdl_x11_create_database(Widget w, XtPointer appData, XtPointer callData);
    static void hdl_x11_done(Widget w, XtPointer appData, XtPointer callData);
};

#endif // XSADB_HH
