//
// Copyright (C) 1996  Lars Berntzon
//
// Description:
//	Main control class for xsadb applikation.
//
extern "C" {
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
}

#include <sadblib.hh>
#include <xsadb.hh>
#include <iostream.h>
#include <XSADB.hh>

#include "xsadb.xbm"

Assoc<SADB> dbList;		// Array of databases.

typedef struct {
    char *saDirectory;
} AppData;

XtAppContext app_context;
AppData appData;

XrmOptionDescRec options[] = {
    {"-sadir", "*saDirectory", XrmoptionSepArg, NULL}
};

XtResource resources[] = {
    {
	"saDirectory",
	"SaDirectory",
	XtRString,
	sizeof(char *),
	XtOffset(AppData *, saDirectory), 
	XtRString,
	""
    }
};

int
main(int argc, char **argv)
{
    Widget topshell;
    Pixmap icon;
    Display *display;
    Window window;
    Arg arg;

    topshell = XtAppInitialize(&app_context,	// Application context.
			  "XSADB",		// Application class.
		          options,		// Options,
		          XtNumber(options),	// Number of options.
		          &argc,		// Pointer to argc.
		          argv,			// Pointer to arguments.
		          NULL,			// Fallback resources.
		          NULL,			// Arguments.
		          0);			// Number of arguments.

    display = XtDisplay(topshell);
    window = DefaultRootWindow(display);

    icon =  XCreateBitmapFromData(display, window, (char *)xsadb_bits, xsadb_width, xsadb_height);
    XtSetArg(arg, XtNiconPixmap, icon);

    XtSetValues(topshell, &arg, 1);

   //XSynchronize(XtDisplay(topshell), 1);


    XtGetApplicationResources(topshell,		// Widget
    			      &appData,		// Base.
    			      resources,	// Resources.
    			      XtNumber(resources), // Num resources
    			      NULL,		// Args.
    			      0);		// Num args

    XSADB xsadb(topshell);

    XtRealizeWidget(topshell);

    XtAppMainLoop(app_context);
}

//
// History of changes:
// $Log: main.cc,v $
// Revision 1.6  1996/09/29 20:45:54  lasse
// Added the remove button to the list panel.
//
// Revision 1.5  1996/09/14 18:33:45  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.4  1996/06/15 19:42:36  lasse
// *** empty log message ***
//
// Revision 1.3  1996/03/21 18:58:00  lasse
// Backup
//
// Revision 1.2  1996/03/12 19:43:23  lasse
// Checking in from remote.
//
//
