/*
 * Copyright 1988 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 *
 *	@(#)gshadow.h	3.4	12:59:05	26 Feb 1994
 */

#ifndef	_H_GSHADOW
#define	_H_GSHADOW

/*
 * Shadow group security file structure
 */

struct	sgrp {
	char	*sg_name;	/* group name */
	char	*sg_passwd;	/* group password */
	char	**sg_adm;	/* group administator list */
	char	**sg_mem;	/* group membership list */
};

/*
 * Shadow group security file functions.
 */

#if defined(__STDC__)
struct	sgrp	*getsgent (void);
struct	sgrp	*getsgnam (const char *);
struct	sgrp	*sgetsgent (const char *);
struct	sgrp	*fgetsgent (FILE *);
void	setsgent (void);
void	endsgent (void);
int	putsgent (const struct sgrp *, FILE *);
#else
struct	sgrp	*getsgent ();
struct	sgrp	*getsgnam ();
struct	sgrp	*sgetsgent ();
struct	sgrp	*fgetsgent ();
void	setsgent ();
void	endsgent ();
int	putsgent ();
#endif

#define	GSHADOW	"/etc/gshadow"
#endif
