/*
 * Copyright 1993 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

#include "config.h"

#ifdef	NEED_RENAME

#include <sys/types.h>
#include <stat.h>
#include <errno.h>

#ifndef	lint
static	char	sccsid[] = "@(#)rename.c	3.1	08:07:35	26 Feb 1995";
#endif

/*
 * rename - rename a file to another name
 *
 *	rename is provided for systems which do not include the rename()
 *	system call.
 */

int
rename (begin, end)
char	*begin;
char	*end;
{
	struct	stat	s1, s2;
	extern	int	errno;
	int	orig_err = errno;

	if (stat (begin, &s1))
		return -1;

	if (stat (end, &s2)) {
		errno = orig_err;
	} else {

		/*
		 * See if this is a cross-device link.  We do this to
		 * insure that the link below has a chance of working.
		 */

		if (s1.st_dev != s2.st_dev) {
			errno = EXDEV;
			return -1;
		}

		/*
		 * See if we can unlink the existing destination
		 * file.  If the unlink works the directory is writable,
		 * so there is no need here to figure that out.
		 */

		if (unlink (end))
			return -1;
	}

	/*
	 * Now just link the original name to the final name.  If there
	 * was no file previously, this link will fail if the target
	 * directory isn't writable.  The unlink will fail if the source
	 * directory isn't writable, but life stinks ...
	 */

	if (link (begin, end) || unlink (begin))
		return -1;

	return 0;
}
#endif
