/*
 * Copyright 1988 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

#ifndef	_H_SHADOW
#define	_H_SHADOW

/*
 * This information is not derived from AT&T licensed sources.  Posted
 * to the USENET 11/88, and updated 11/90 with information from SVR4.
 *
 *	@(#)shadow.h	3.5	10:54:38	26 Feb 1994
 */

#ifdef	ITI_AGING
typedef	time_t	sptime;
#else
typedef	long	sptime;
#endif

/*
 * Shadow password security file structure.
 */

struct	spwd {
	char	*sp_namp;	/* login name */
	char	*sp_pwdp;	/* encrypted password */
	sptime	sp_lstchg;	/* date of last change */
	sptime	sp_min;		/* minimum number of days between changes */
	sptime	sp_max;		/* maximum number of days between changes */
	sptime	sp_warn;	/* number of days of warning before password
				   expires */
	sptime	sp_inact;	/* number of days after password expires
				   until the account becomes unusable. */
	sptime	sp_expire;	/* days since 1/1/70 until account expires */
	unsigned long	sp_flag; /* reserved for future use */
};

/*
 * Shadow password security file functions.
 */

#if defined(__STDC__)
struct	spwd	*getspent (void);
struct	spwd	*getspnam (const char *);
struct	spwd	*sgetspent (const char *);
struct	spwd	*fgetspent (FILE *);
void	setspent (void);
void	endspent (void);
int	putspent (const struct spwd *, FILE *);
#else
struct	spwd	*getspent ();
struct	spwd	*getspnam ();
struct	spwd	*sgetspent ();
struct	spwd	*fgetspent ();
void	setspent ();
void	endspent ();
int	putspent ();
#endif

#define  SHADOW "/etc/shadow"
#endif
