/*
 * Copyright 1989 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

#include <stdio.h>
#ifndef	BSD
#include <string.h>
#include <memory.h>
#else
#include <strings.h>
#define	strchr	index
#define	strrchr	rindex
#endif
#include "config.h"

#ifndef	lint
static	char	_sccsid[] = "@(#)ttytype.c	3.4	20:11:07	08 Feb 1994";
#endif

extern	char	*getdef_str();

/*
 * ttytype - set ttytype from port to terminal type mapping database
 */

void
ttytype (line)
char	*line;
{
	FILE	*fp;
	char	buf[BUFSIZ];
	char	termvar[BUFSIZ];
	char	*typefile;
	char	*cp;
	char	type[BUFSIZ];
	char	port[BUFSIZ];
	char	*getenv ();

	if (getenv ("TERM"))
		return;
	if ((typefile=getdef_str("TTYTYPE_FILE")) == NULL )
		return;
	if (access (typefile, 0))
		return;

	if (! (fp = fopen (typefile, "r"))) {
		perror (typefile);
		return;
	}
	while (fgets (buf, BUFSIZ, fp)) {
		if (buf[0] == '#')
			continue;

		if (cp = strchr (buf, '\n'))
			*cp = '\0';

#if defined(SUN) || defined(BSD) || defined(SUN4)
		if ((sscanf (buf, "%s \"%*[^\"]\" %s", port, type) == 2 ||
				sscanf (buf, "%s %*s %s", port, type) == 2) &&
				strcmp (line, port) == 0)
			break;
#else	/* USG */
		if (sscanf (buf, "%s %s", type, port) == 2 &&
				strcmp (line, port) == 0)
			break;
#endif
	}
	if (! feof (fp) && ! ferror (fp)) {
		strcat (strcpy (termvar, "TERM="), type);
		addenv (termvar);
	}
	fclose (fp);
}
