/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntArray;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "value", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "<init>", "(Ljava/util/List;)V", "getValue", "()Ljava/util/List;", "toBytes", "", "dump", "", "indent", "startAddress", "sizeInBytes", "getSizeInBytes", "()I", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nConstantData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantData.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1586#2:151\n1661#2,3:152\n*S KotlinDebug\n*F\n+ 1 ConstantData.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntArray\n*L\n79#1:151\n79#1:152,3\n*E\n"})
public final class ConstantDataIntArray
extends ConstantDataElement {
    @NotNull
    private final List<WasmSymbol<Integer>> value;
    private final int sizeInBytes;

    public ConstantDataIntArray(@NotNull List<WasmSymbol<Integer>> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super(null);
        this.value = value;
        this.sizeInBytes = this.value.size() * 4;
    }

    @NotNull
    public final List<WasmSymbol<Integer>> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        byte[] byArray;
        byte[] $this$toBytes_u24lambda_u240 = byArray = new byte[this.value.size() * 4];
        boolean bl = false;
        int n = ((Collection)this.value).size();
        for (int index = 0; index < n; ++index) {
            ConstantDataKt.toLittleEndianBytes(((Number)this.value.get(index).getOwner()).intValue(), $this$toBytes_u24lambda_u240, index * 4);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (this.value.isEmpty()) {
            return "";
        }
        Iterable iterable = this.value;
        StringBuilder stringBuilder = new StringBuilder().append(ConstantDataKt.access$addressToString(startAddress)).append(": ").append(indent).append(" i32[] : ");
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmSymbol wasmSymbol = (WasmSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getOwner()).intValue());
        }
        String string = Arrays.toString(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).append("   ;;\n").toString();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

