/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.BaseRevisionStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\f\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/DefaultLocalStatusTrackerProvider;", "Lcom/intellij/openapi/vcs/impl/BaseRevisionStatusTrackerContentLoader;", "<init>", "()V", "isTrackedFile", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "isMyTracker", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "createTracker", "intellij.platform.vcs.impl"})
final class DefaultLocalStatusTrackerProvider
extends BaseRevisionStatusTrackerContentLoader {
    @NotNull
    public static final DefaultLocalStatusTrackerProvider INSTANCE = new DefaultLocalStatusTrackerProvider();

    private DefaultLocalStatusTrackerProvider() {
    }

    @Override
    public boolean isTrackedFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = VcsUtil.resolveSymlinkIfNeeded((Project)project, (VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"resolveSymlinkIfNeeded(...)");
        VirtualFile vcsFile = virtualFile;
        return super.isTrackedFile(project, vcsFile);
    }

    @Override
    @Nullable
    public LineStatusTrackerContentLoader.ContentInfo getContentInfo(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = VcsUtil.resolveSymlinkIfNeeded((Project)project, (VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"resolveSymlinkIfNeeded(...)");
        VirtualFile vcsFile = virtualFile;
        return super.getContentInfo(project, vcsFile);
    }

    @Override
    public boolean isMyTracker(@NotNull LocalLineStatusTracker<?> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return tracker instanceof SimpleLocalLineStatusTracker;
    }

    @Override
    @Nullable
    public LocalLineStatusTracker<?> createTracker(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return SimpleLocalLineStatusTracker.Companion.createTracker(project, document2, file);
    }
}

