/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.LruCacheKey;

public abstract class AbstractLruCache<Key extends LruCacheKey> {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractLruCache.class);
    protected final ConcurrentLinkedHashMap<Key, Boolean> accessRecencyMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();

    protected AbstractLruCache() {
    }

    protected void updateAccess(Key key) {
        if (key == null) {
            return;
        }
        this.accessRecencyMap.put(key, (Object)true);
    }

    protected Key getLeastRecentlyUsedItem() {
        Set keySet = this.accessRecencyMap.ascendingKeySetWithLimit(1);
        return (Key)(keySet.isEmpty() ? null : (LruCacheKey)keySet.iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(long ramBytesToRelease) {
        long ramBytesReleased;
        if (ramBytesToRelease <= 0L) {
            return;
        }
        ConcurrentLinkedHashMap<Key, Boolean> concurrentLinkedHashMap = this.accessRecencyMap;
        synchronized (concurrentLinkedHashMap) {
            Key leastRecentlyUsedKey;
            for (ramBytesReleased = 0L; ramBytesReleased < ramBytesToRelease && (leastRecentlyUsedKey = this.getLeastRecentlyUsedItem()) != null; ramBytesReleased += this.evictItem(leastRecentlyUsedKey)) {
            }
        }
        log.debug("Freed {} bytes of memory", (Object)ramBytesReleased);
    }

    protected long evictItem(Key key) {
        if (this.accessRecencyMap.remove(key) == null) {
            return 0L;
        }
        return this.doEviction(key);
    }

    public void onIndexRemoval(@NonNull CacheKey cacheKey) {
        Objects.requireNonNull(cacheKey, "cacheKey is marked non-null but is null");
        this.accessRecencyMap.keySet().removeIf(key -> key.getCacheKey().equals(cacheKey));
    }

    protected abstract long doEviction(Key var1);
}

