/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.exceptions.DataSourceNotFoundException;
import org.opensearch.sql.datasources.exceptions.ErrorMessage;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.GetDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.GetDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.PatchDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.PatchDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionResponse;
import org.opensearch.sql.datasources.transport.TransportCreateDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportDeleteDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportGetDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportPatchDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportUpdateDataSourceAction;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.datasources.utils.XContentParserUtils;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.utils.MetricUtils;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.opensearch.util.RestRequestUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestDataSourceQueryAction
extends BaseRestHandler {
    public static final String DATASOURCE_ACTIONS = "datasource_actions";
    public static final String BASE_DATASOURCE_ACTION_URL = "/_plugins/_query/_datasources";
    private static final Logger LOG = LogManager.getLogger(RestDataSourceQueryAction.class);
    private final OpenSearchSettings settings;

    public String getName() {
        return DATASOURCE_ACTIONS;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", BASE_DATASOURCE_ACTION_URL, "dataSourceName")), (Object)new RestHandler.Route(RestRequest.Method.GET, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.PUT, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.PATCH, BASE_DATASOURCE_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", BASE_DATASOURCE_ACTION_URL, "dataSourceName")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        if (!this.enabled()) {
            return this.disabledError(restRequest);
        }
        switch (restRequest.method()) {
            case POST: {
                return this.executePostRequest(restRequest, nodeClient);
            }
            case GET: {
                return this.executeGetRequest(restRequest, nodeClient);
            }
            case PUT: {
                return this.executeUpdateRequest(restRequest, nodeClient);
            }
            case DELETE: {
                return this.executeDeleteRequest(restRequest, nodeClient);
            }
            case PATCH: {
                return this.executePatchRequest(restRequest, nodeClient);
            }
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(restRequest.method())));
    }

    private BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_CREATION_REQ_COUNT);
        DataSourceMetadata dataSourceMetadata = XContentParserUtils.toDataSourceMetadata(restRequest.contentParser());
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportCreateDataSourceAction.ACTION_TYPE, (ActionRequest)new CreateDataSourceActionRequest(dataSourceMetadata), (ActionListener)new ActionListener<CreateDataSourceActionResponse>(){

            public void onResponse(CreateDataSourceActionResponse createDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, "application/json; charset=UTF-8", createDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeGetRequest(RestRequest restRequest, NodeClient nodeClient) {
        MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_GET_REQ_COUNT);
        String dataSourceName = restRequest.param("dataSourceName");
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportGetDataSourceAction.ACTION_TYPE, (ActionRequest)new GetDataSourceActionRequest(dataSourceName), (ActionListener)new ActionListener<GetDataSourceActionResponse>(){

            public void onResponse(GetDataSourceActionResponse getDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", getDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeUpdateRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_PUT_REQ_COUNT);
        DataSourceMetadata dataSourceMetadata = XContentParserUtils.toDataSourceMetadata(restRequest.contentParser());
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportUpdateDataSourceAction.ACTION_TYPE, (ActionRequest)new UpdateDataSourceActionRequest(dataSourceMetadata), (ActionListener)new ActionListener<UpdateDataSourceActionResponse>(){

            public void onResponse(UpdateDataSourceActionResponse updateDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", updateDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executePatchRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_PATCH_REQ_COUNT);
        Map<String, Object> dataSourceData = XContentParserUtils.toMap(restRequest.contentParser());
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportPatchDataSourceAction.ACTION_TYPE, (ActionRequest)new PatchDataSourceActionRequest(dataSourceData), (ActionListener)new ActionListener<PatchDataSourceActionResponse>(){

            public void onResponse(PatchDataSourceActionResponse patchDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", patchDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeDeleteRequest(RestRequest restRequest, NodeClient nodeClient) {
        MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_DELETE_REQ_COUNT);
        String dataSourceName = restRequest.param("dataSourceName");
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportDeleteDataSourceAction.ACTION_TYPE, (ActionRequest)new DeleteDataSourceActionRequest(dataSourceName), (ActionListener)new ActionListener<DeleteDataSourceActionResponse>(){

            public void onResponse(DeleteDataSourceActionResponse deleteDataSourceActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NO_CONTENT, "application/json; charset=UTF-8", deleteDataSourceActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestDataSourceQueryAction.this.handleException(e, restChannel);
            }
        }));
    }

    private void handleException(Exception e, RestChannel restChannel) {
        if (e instanceof DataSourceNotFoundException) {
            MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_FAILED_REQ_COUNT_CUS);
            this.reportError(restChannel, e, RestStatus.NOT_FOUND);
        } else if (e instanceof OpenSearchSecurityException) {
            MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_FAILED_REQ_COUNT_CUS);
            OpenSearchSecurityException exception = (OpenSearchSecurityException)e;
            this.reportError(restChannel, (Exception)exception, exception.status());
        } else if (e instanceof OpenSearchException) {
            MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_FAILED_REQ_COUNT_SYS);
            OpenSearchException exception = (OpenSearchException)e;
            this.reportError(restChannel, (Exception)exception, exception.status());
        } else {
            LOG.error("Error happened during request handling", (Throwable)e);
            if (RestDataSourceQueryAction.isClientError(e)) {
                MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_FAILED_REQ_COUNT_CUS);
                this.reportError(restChannel, e, RestStatus.BAD_REQUEST);
            } else {
                MetricUtils.incrementNumericalMetric((MetricName)MetricName.DATASOURCE_FAILED_REQ_COUNT_SYS);
                this.reportError(restChannel, e, RestStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, new ErrorMessage(e, status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof IllegalArgumentException || e instanceof IllegalStateException;
    }

    private boolean enabled() {
        return (Boolean)this.settings.getSettingValue(Settings.Key.DATASOURCES_ENABLED);
    }

    private BaseRestHandler.RestChannelConsumer disabledError(RestRequest request) {
        RestRequestUtil.consumeAllRequestParameters((RestRequest)request);
        return channel -> this.reportError((RestChannel)channel, (Exception)new OpenSearchStatusException(String.format("%s setting is false", Settings.Key.DATASOURCES_ENABLED.getKeyValue()), RestStatus.BAD_REQUEST, new Object[0]), RestStatus.BAD_REQUEST);
    }

    @Generated
    public RestDataSourceQueryAction(OpenSearchSettings settings) {
        this.settings = settings;
    }
}

