/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;

public class FillNull
extends UnresolvedPlan {
    private Optional<UnresolvedExpression> replacementForAll = Optional.empty();
    private final List<Pair<Field, UnresolvedExpression>> replacementPairs;
    private final boolean useValueSyntax;
    private UnresolvedPlan child;

    public static FillNull ofVariousValue(List<Pair<Field, UnresolvedExpression>> replacements) {
        return new FillNull(replacements, false);
    }

    public static FillNull ofSameValue(UnresolvedExpression replacement, List<Field> fieldList) {
        return FillNull.ofSameValue(replacement, fieldList, false);
    }

    public static FillNull ofSameValue(UnresolvedExpression replacement, List<Field> fieldList, boolean useValueSyntax) {
        List<Pair<Field, UnresolvedExpression>> replacementPairs = fieldList.stream().map(f -> Pair.of((Object)f, (Object)replacement)).toList();
        FillNull instance = new FillNull(replacementPairs, useValueSyntax);
        if (replacementPairs.isEmpty()) {
            instance.replacementForAll = Optional.of(replacement);
        }
        return instance;
    }

    FillNull(List<Pair<Field, UnresolvedExpression>> replacementPairs, boolean useValueSyntax) {
        this.replacementPairs = replacementPairs;
        this.useValueSyntax = useValueSyntax;
    }

    public List<Field> getFields() {
        return this.getReplacementPairs().stream().map(Pair::getLeft).toList();
    }

    public boolean isAgainstAllFields() {
        return !this.replacementForAll.isEmpty() && this.getReplacementPairs().isEmpty();
    }

    @Override
    public FillNull attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    @Override
    public List<? extends Node> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitFillNull(this, context);
    }

    @Generated
    public Optional<UnresolvedExpression> getReplacementForAll() {
        return this.replacementForAll;
    }

    @Generated
    public List<Pair<Field, UnresolvedExpression>> getReplacementPairs() {
        return this.replacementPairs;
    }

    @Generated
    public boolean isUseValueSyntax() {
        return this.useValueSyntax;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FillNull)) {
            return false;
        }
        FillNull other = (FillNull)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseValueSyntax() != other.isUseValueSyntax()) {
            return false;
        }
        Optional<UnresolvedExpression> this$replacementForAll = this.getReplacementForAll();
        Optional<UnresolvedExpression> other$replacementForAll = other.getReplacementForAll();
        if (this$replacementForAll == null ? other$replacementForAll != null : !((Object)this$replacementForAll).equals(other$replacementForAll)) {
            return false;
        }
        List<Pair<Field, UnresolvedExpression>> this$replacementPairs = this.getReplacementPairs();
        List<Pair<Field, UnresolvedExpression>> other$replacementPairs = other.getReplacementPairs();
        if (this$replacementPairs == null ? other$replacementPairs != null : !((Object)this$replacementPairs).equals(other$replacementPairs)) {
            return false;
        }
        List<? extends Node> this$child = this.getChild();
        List<? extends Node> other$child = other.getChild();
        return !(this$child == null ? other$child != null : !((Object)this$child).equals(other$child));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FillNull;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseValueSyntax() ? 79 : 97);
        Optional<UnresolvedExpression> $replacementForAll = this.getReplacementForAll();
        result = result * 59 + ($replacementForAll == null ? 43 : ((Object)$replacementForAll).hashCode());
        List<Pair<Field, UnresolvedExpression>> $replacementPairs = this.getReplacementPairs();
        result = result * 59 + ($replacementPairs == null ? 43 : ((Object)$replacementPairs).hashCode());
        List<? extends Node> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FillNull(replacementForAll=" + String.valueOf(this.getReplacementForAll()) + ", replacementPairs=" + String.valueOf(this.getReplacementPairs()) + ", useValueSyntax=" + this.isUseValueSyntax() + ", child=" + String.valueOf(this.getChild()) + ")";
    }
}

