/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tasks;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.tasks.OracleToolTableTruncateSettings;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleToolTableTruncate
extends SQLToolExecuteHandler<OracleTableBase, OracleToolTableTruncateSettings> {
    @NotNull
    public OracleToolTableTruncateSettings createToolSettings() {
        return new OracleToolTableTruncateSettings();
    }

    public void generateObjectQueries(DBCSession session, OracleToolTableTruncateSettings settings, List<DBEPersistAction> queries, OracleTableBase object) {
        StringBuilder sql = new StringBuilder(32);
        if (object instanceof OracleTablePartition) {
            OracleTablePartition partition = (OracleTablePartition)object;
            sql.append("ALTER TABLE ").append(partition.getParent().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" TRUNCATE ");
            if (partition.isSubPartition()) {
                sql.append("SUB");
            }
            sql.append("PARTITION ").append(DBUtils.getQuotedIdentifier((DBSObject)object));
        } else {
            sql.append("TRUNCATE TABLE ").append(object.getFullyQualifiedName(DBPEvaluationContext.DDL));
        }
        if (settings.isReusable()) {
            sql.append(" REUSE STORAGE");
        }
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql.toString()));
    }

    public boolean needsRefreshOnFinish() {
        return true;
    }
}

