/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class LauncherDiscoveryResult {
    private final Map<TestEngine, TestDescriptor> testEngineDescriptors;
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryProvider outputDirectoryProvider;

    LauncherDiscoveryResult(Map<TestEngine, TestDescriptor> testEngineDescriptors, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider) {
        this.testEngineDescriptors = Collections.unmodifiableMap(new LinkedHashMap<TestEngine, TestDescriptor>(testEngineDescriptors));
        this.configurationParameters = configurationParameters;
        this.outputDirectoryProvider = outputDirectoryProvider;
    }

    public TestDescriptor getEngineTestDescriptor(TestEngine testEngine) {
        return this.testEngineDescriptors.get(testEngine);
    }

    ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    OutputDirectoryProvider getOutputDirectoryProvider() {
        return this.outputDirectoryProvider;
    }

    public Collection<TestEngine> getTestEngines() {
        return this.testEngineDescriptors.keySet();
    }

    Collection<TestDescriptor> getEngineTestDescriptors() {
        return this.testEngineDescriptors.values();
    }

    public LauncherDiscoveryResult withRetainedEngines(Predicate<? super TestDescriptor> predicate) {
        Map<TestEngine, TestDescriptor> prunedTestEngineDescriptors = this.retainEngines(predicate);
        if (prunedTestEngineDescriptors.size() < this.testEngineDescriptors.size()) {
            return new LauncherDiscoveryResult(prunedTestEngineDescriptors, this.configurationParameters, this.outputDirectoryProvider);
        }
        return this;
    }

    private Map<TestEngine, TestDescriptor> retainEngines(Predicate<? super TestDescriptor> predicate) {
        return this.testEngineDescriptors.entrySet().stream().filter(entry -> predicate.test((TestDescriptor)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

