/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Cursor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.util.Collections;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.view.swing.map.outline.NodeButton;

class OutlineNodeDragGestureListener
implements DragGestureListener {
    private final NodeButton nodeButton;

    OutlineNodeDragGestureListener(NodeButton nodeButton) {
        this.nodeButton = nodeButton;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        NodeModel nodeModel = this.nodeButton.getNodeModel();
        if (nodeModel == null) {
            return;
        }
        DragAction dragAction = this.determineDragAction(dragGestureEvent);
        MindMapNodesSelection transferable = MapClipboardController.getController().copy(Collections.singletonList(nodeModel), MapClipboardController.CopiedNodeSet.ALL_NODES, MapClipboardController.CopiedNodeSet.ALL_NODES);
        if (transferable instanceof MindMapNodesSelection) {
            MindMapNodesSelection nodeSelection = transferable;
            nodeSelection.setDropAction(dragAction.actionType);
            nodeSelection.setNodeObjects(Collections.singletonList(nodeModel), false);
        }
        dragGestureEvent.startDrag(dragAction.cursor, transferable);
    }

    private DragAction determineDragAction(DragGestureEvent dragGestureEvent) {
        int dragActionType = dragGestureEvent.getDragAction();
        Cursor cursor = this.getCursor(dragActionType);
        int modifiers = dragGestureEvent.getTriggerEvent().getModifiersEx();
        if ((modifiers & 0x800) != 0) {
            dragActionType = 1;
            cursor = DragSource.DefaultCopyDrop;
        } else if ((modifiers & 0x1000) != 0) {
            dragActionType = 0x40000000;
            cursor = DragSource.DefaultLinkDrop;
        }
        return new DragAction(cursor, dragActionType);
    }

    private Cursor getCursor(int dragActionType) {
        switch (dragActionType) {
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }

    private static class DragAction {
        private final Cursor cursor;
        private final int actionType;

        private DragAction(Cursor cursor, int actionType) {
            this.cursor = cursor;
            this.actionType = actionType;
        }
    }
}

