/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.PeakInfo;
import jspecview.common.Spectrum;
import jspecview.source.JDXSource;
import org.jmol.util.Logger;

public class SyncManager {
    private static String testScript = "<PeakData  index=\"1\" title=\"\" model=\"~1.1\" type=\"1HNMR\" xMin=\"3.2915\" xMax=\"3.2965\" atoms=\"15,16,17,18,19,20\" multiplicity=\"\" integral=\"1\"> src=\"JPECVIEW\" file=\"http://SIMULATION/$caffeine\"";

    static void syncToJmol(JSViewer jSViewer, PeakInfo peakInfo) {
        jSViewer.peakInfoModelSentToJmol = peakInfo.getModel();
        jSViewer.si.syncToJmol(SyncManager.jmolSelect(jSViewer.pd(), peakInfo));
    }

    public static void syncFromJmol(JSViewer jSViewer, String string) {
        String string2;
        String string3;
        Object object;
        String string4;
        String string5;
        String string6;
        String string7;
        if (string.equals("TEST")) {
            string = testScript;
        }
        if (string.indexOf("<PeakData") < 0) {
            if (string.startsWith("JSVSTR:")) {
                jSViewer.si.syncToJmol(string);
                return;
            }
            jSViewer.runScriptNow(string);
            if (string.indexOf("#SYNC_PEAKS") >= 0) {
                SyncManager.syncToJmolPeaksAfterSyncScript(jSViewer);
            }
            return;
        }
        String string8 = PT.getQuotedAttribute(string, "sourceID");
        if (string8 == null) {
            string7 = PT.getQuotedAttribute(string, "file");
            string6 = PT.getQuotedAttribute(string, "index");
            if (string7 == null || string6 == null) {
                return;
            }
            string7 = PT.rep(string7, "#molfile", "");
            string5 = PT.getQuotedAttribute(string, "model");
            string4 = PT.getQuotedAttribute(string, "src");
            Object object2 = object = string4 != null && string4.startsWith("Jmol") ? null : jSViewer.peakInfoModelSentToJmol;
            if (string5 != null && object != null && !string5.equals(object)) {
                Logger.info("JSV ignoring model " + string5 + "; should be " + (String)object);
                return;
            }
            jSViewer.peakInfoModelSentToJmol = null;
            if (jSViewer.panelNodes.size() == 0 || !jSViewer.checkFileAlreadyLoaded(string7)) {
                Logger.info("file " + string7 + " not found -- JSViewer closing all and reopening");
                jSViewer.si.siSyncLoad(string7);
            }
            string3 = PT.getQuotedAttribute(string, "type");
            string2 = null;
        } else {
            string7 = null;
            string6 = string5 = string8;
            string2 = "," + PT.getQuotedAttribute(string, "atom") + ",";
            string3 = "ID";
            string4 = string8;
        }
        object = SyncManager.selectPanelByPeak(jSViewer, string7, string6, string2);
        PanelData panelData = jSViewer.pd();
        panelData.selectSpectrum(string7, string3, string5, true);
        jSViewer.si.siSendPanelChange();
        panelData.addPeakHighlight((PeakInfo)object);
        jSViewer.repaint(true);
        if (string4 == null || object != null && ((PeakInfo)object).getAtoms() != null) {
            jSViewer.si.syncToJmol(SyncManager.jmolSelect(jSViewer.pd(), (PeakInfo)object));
        }
    }

    private static void syncToJmolPeaksAfterSyncScript(JSViewer jSViewer) {
        JDXSource jDXSource = jSViewer.currentSource;
        if (jDXSource == null) {
            return;
        }
        try {
            String string = "file=" + PT.esc(jDXSource.getFilePath());
            Lst<Spectrum> lst = jDXSource.getSpectra();
            Lst<PeakInfo> lst2 = ((Spectrum)lst.get(lst.size() - 1)).getPeakList();
            SB sB = new SB();
            sB.append("[");
            int n = lst2.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = ((PeakInfo)lst2.get(n2)).toString();
                string2 = String.valueOf(string2) + " " + string;
                sB.append(PT.esc(string2));
                if (n2 > 0) {
                    sB.append(",");
                }
                ++n2;
            }
            sB.append("]");
            jSViewer.si.syncToJmol("Peaks: " + sB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static PeakInfo selectPanelByPeak(JSViewer jSViewer, String string, String string2, String string3) {
        Lst<PanelNode> lst = jSViewer.panelNodes;
        if (lst == null) {
            return null;
        }
        PeakInfo peakInfo = null;
        int n = lst.size();
        while (--n >= 0) {
            ((PanelNode)lst.get(n)).pd().addPeakHighlight(null);
        }
        peakInfo = jSViewer.pd().selectPeakByFileIndex(string, string2, string3);
        if (peakInfo != null) {
            jSViewer.setNode(PanelNode.findNode(jSViewer.selectedPanel, lst));
        } else {
            n = lst.size();
            while (--n >= 0) {
                PanelNode panelNode = (PanelNode)lst.get(n);
                peakInfo = panelNode.pd().selectPeakByFileIndex(string, string2, string3);
                if (peakInfo == null) continue;
                jSViewer.setNode(panelNode);
                break;
            }
        }
        return peakInfo;
    }

    private static String jmolSelect(PanelData panelData, PeakInfo peakInfo) {
        String string = "IR".equals(peakInfo.getType()) || "RAMAN".equals(peakInfo.getType()) ? "vibration ON; selectionHalos OFF;" : "vibration OFF; selectionhalos " + (peakInfo.getAtoms() == null ? "OFF" : "ON");
        return "Select: " + peakInfo + " script=\"" + string + " \" sourceID=\"" + panelData.getSpectrum().sourceID + "\"";
    }
}

