/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.task.InstrumentsDb;

class LostFilesTableModel
extends AbstractTableModel {
    public LostFilesTableModel() {
        CC.getLostFilesModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LostFilesTableModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return CC.getLostFilesModel().getLostFileCount();
    }

    @Override
    public String getColumnName(int n) {
        return JSI18n.i18n.getLabel("LostFilesTableModel.title");
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return CC.getLostFilesModel().getLostFile(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = CC.getLostFilesModel().getLostFile(n);
        String string2 = object.toString();
        if (string2.equals(string)) {
            return;
        }
        InstrumentsDb.SetInstrumentFilePath setInstrumentFilePath = new InstrumentsDb.SetInstrumentFilePath(string, string2);
        setInstrumentFilePath.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                CC.getLostFilesModel().update();
            }
        });
        CC.getTaskQueue().add(setInstrumentFilePath);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }
}

