Clazz.declarePackage("JU");
Clazz.load(["JU.T3d"], "JU.V3d", null, function(){
var c$ = Clazz.declareType(JU, "V3d", JU.T3d);
Clazz.defineMethod(c$, "cross", 
function(v1, v2){
this.set(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
}, "JU.V3d,JU.V3d");
Clazz.defineMethod(c$, "normalize", 
function(){
var d = this.length();
this.x /= d;
this.y /= d;
this.z /= d;
});
Clazz.defineMethod(c$, "angle", 
function(v1){
var xx = this.y * v1.z - this.z * v1.y;
var yy = this.z * v1.x - this.x * v1.z;
var zz = this.x * v1.y - this.y * v1.x;
var cross = Math.sqrt(xx * xx + yy * yy + zz * zz);
return Math.abs(Math.atan2(cross, this.dot(v1)));
}, "JU.V3d");
Clazz.defineMethod(c$, "dot", 
function(v){
return this.x * v.x + this.y * v.y + this.z * v.z;
}, "JU.V3d");
Clazz.defineMethod(c$, "lengthSquared", 
function(){
return this.x * this.x + this.y * this.y + this.z * this.z;
});
Clazz.defineMethod(c$, "length", 
function(){
return Math.sqrt(this.lengthSquared());
});
});
;//5.0.1-v7 Sat Jan 10 11:40:46 CST 2026
