/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RecursiveAction;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.SetOnce;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.store.remote.filecache.AggregateFileCacheStats;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCacheStats;
import org.opensearch.index.store.remote.utils.FileTypeUtils;
import org.opensearch.index.store.remote.utils.cache.RefCountedCache;
import org.opensearch.index.store.remote.utils.cache.SegmentedCache;
import org.opensearch.index.store.remote.utils.cache.stats.AggregateRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.IRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.RefCountedCacheStats;

@PublicApi(since="2.7.0")
public class FileCache
implements RefCountedCache<Path, CachedIndexInput> {
    private static final Logger logger = LogManager.getLogger(FileCache.class);
    private final SegmentedCache<Path, CachedIndexInput> theCache;
    private final CircuitBreaker circuitBreaker = null;

    @Deprecated(forRemoval=true)
    public FileCache(SegmentedCache<Path, CachedIndexInput> cache, CircuitBreaker circuitBreaker) {
        this(cache);
    }

    public FileCache(SegmentedCache<Path, CachedIndexInput> theCache) {
        this.theCache = theCache;
    }

    public long capacity() {
        return this.theCache.capacity();
    }

    @Override
    public CachedIndexInput put(Path filePath, CachedIndexInput indexInput) {
        CachedIndexInput cachedIndexInput = this.theCache.put(filePath, indexInput);
        return cachedIndexInput;
    }

    @Override
    public CachedIndexInput compute(Path key, BiFunction<? super Path, ? super CachedIndexInput, ? extends CachedIndexInput> remappingFunction) {
        CachedIndexInput cachedIndexInput = this.theCache.compute(key, remappingFunction);
        return cachedIndexInput;
    }

    @Override
    public CachedIndexInput get(Path filePath) {
        return this.theCache.get(filePath);
    }

    @Override
    public void remove(Path filePath) {
        this.theCache.remove(filePath);
    }

    @Override
    public void clear() {
        this.theCache.clear();
    }

    @Override
    public long size() {
        return this.theCache.size();
    }

    @Override
    public void incRef(Path key) {
        this.theCache.incRef(key);
    }

    @Override
    public void decRef(Path key) {
        this.theCache.decRef(key);
    }

    @Override
    public void pin(Path key) {
        this.theCache.pin(key);
    }

    @Override
    public void unpin(Path key) {
        this.theCache.unpin(key);
    }

    @Override
    public Integer getRef(Path key) {
        return this.theCache.getRef(key);
    }

    @Override
    public long prune() {
        return this.theCache.prune();
    }

    @Override
    public long prune(Predicate<Path> keyPredicate) {
        return this.theCache.prune(keyPredicate);
    }

    @Override
    public long usage() {
        return this.theCache.usage();
    }

    @Override
    public long activeUsage() {
        return this.theCache.activeUsage();
    }

    @Override
    public long pinnedUsage() {
        return this.theCache.pinnedUsage();
    }

    @Override
    public IRefCountedCacheStats stats() {
        return this.theCache.stats();
    }

    public void logCurrentState() {
        logger.trace("CURRENT STATE OF FILE CACHE \n");
        long cacheUsage = this.theCache.usage();
        logger.trace("Total Usage: " + cacheUsage + " , Active Usage: " + this.theCache.activeUsage());
        this.theCache.logCurrentState();
    }

    public void closeIndexInputReferences() {
        this.theCache.closeIndexInputReferences();
    }

    public void restoreFromDirectory(List<Path> fileCacheDataPaths) {
        Stream.concat(fileCacheDataPaths.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.resolve("RemoteLocalStore")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])), fileCacheDataPaths.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.resolve(FileTypeUtils.INDICES_FOLDER_IDENTIFIER)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).flatMap(dir -> {
            try {
                return Files.list(dir);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to process file cache directory. Please clear the file cache for node startup.", e);
            }
        }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            try {
                this.put(path.toAbsolutePath(), new RestoredCachedIndexInput(Files.size(path)));
                this.decRef(path.toAbsolutePath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to retrieve cache file details. Please clear the file cache for node startup.", e);
            }
        });
    }

    public AggregateFileCacheStats fileCacheStats() {
        AggregateRefCountedCacheStats stats = (AggregateRefCountedCacheStats)this.stats();
        RefCountedCacheStats overallCacheStats = stats.getOverallCacheStats();
        RefCountedCacheStats fullFileCacheStats = stats.getFullFileCacheStats();
        RefCountedCacheStats blockFileCacheStats = stats.getBlockFileCacheStats();
        RefCountedCacheStats pinnedFileCacheStats = stats.getPinnedFileCacheStats();
        return new AggregateFileCacheStats(System.currentTimeMillis(), new FileCacheStats(overallCacheStats.activeUsage(), this.capacity(), overallCacheStats.usage(), overallCacheStats.pinnedUsage(), overallCacheStats.evictionWeight(), overallCacheStats.hitCount(), overallCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.OVER_ALL_STATS), new FileCacheStats(fullFileCacheStats.activeUsage(), this.capacity(), fullFileCacheStats.usage(), fullFileCacheStats.pinnedUsage(), fullFileCacheStats.evictionWeight(), fullFileCacheStats.hitCount(), fullFileCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.FULL_FILE_STATS), new FileCacheStats(blockFileCacheStats.activeUsage(), this.capacity(), blockFileCacheStats.usage(), blockFileCacheStats.pinnedUsage(), blockFileCacheStats.evictionWeight(), blockFileCacheStats.hitCount(), blockFileCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.BLOCK_FILE_STATS), new FileCacheStats(pinnedFileCacheStats.activeUsage(), this.capacity(), pinnedFileCacheStats.usage(), pinnedFileCacheStats.pinnedUsage(), pinnedFileCacheStats.evictionWeight(), pinnedFileCacheStats.hitCount(), pinnedFileCacheStats.missCount(), AggregateFileCacheStats.FileCacheStatsType.PINNED_FILE_STATS));
    }

    public static class RestoredCachedIndexInput
    implements CachedIndexInput {
        private final long length;

        public RestoredCachedIndexInput(long length) {
            this.length = length;
        }

        @Override
        public IndexInput getIndexInput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static class LoadTask
    extends RecursiveAction {
        private final Path path;
        private final FileCache fc;
        private final boolean processedDirectory;
        private final SetOnce<UncheckedIOException> exception;

        public LoadTask(Path path, FileCache fc, SetOnce<UncheckedIOException> exception) {
            this.path = path;
            this.fc = fc;
            this.exception = exception;
            this.processedDirectory = false;
        }

        public LoadTask(Path path, FileCache fc, SetOnce<UncheckedIOException> exception, boolean processedDirectory) {
            this.path = path;
            this.fc = fc;
            this.exception = exception;
            this.processedDirectory = processedDirectory;
        }

        @Override
        public void compute() {
            ArrayList<LoadTask> subTasks;
            block15: {
                subTasks = new ArrayList<LoadTask>();
                try {
                    if (this.processedDirectory) {
                        this.fc.restoreFromDirectory(List.of(this.path));
                        break block15;
                    }
                    if (!Files.isDirectory(this.path, new LinkOption[0])) break block15;
                    try (DirectoryStream<Path> indexStream = Files.newDirectoryStream(this.path);){
                        for (Path indexPath : indexStream) {
                            if (!Files.isDirectory(indexPath, new LinkOption[0])) continue;
                            ArrayList<Path> indexSubPaths = new ArrayList<Path>();
                            NodeEnvironment.processDirectoryFiles(indexPath, indexSubPaths);
                            for (Path indexSubPath : indexSubPaths) {
                                subTasks.add(new LoadTask(indexSubPath, this.fc, this.exception, true));
                            }
                        }
                    }
                }
                catch (IOException | UncheckedIOException e) {
                    try {
                        if (e instanceof UncheckedIOException) {
                            this.exception.set((Object)((UncheckedIOException)e));
                        } else {
                            this.exception.set((Object)new UncheckedIOException("Unable to process directories.", (IOException)e));
                        }
                    }
                    catch (SetOnce.AlreadySetException alreadySetException) {
                        // empty catch block
                    }
                    return;
                }
            }
            LoadTask.invokeAll(subTasks);
        }
    }
}

