/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SoftDeletesRetentionMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.common.lucene.LoggerInfoStream;
import org.opensearch.core.Assertions;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.CriteriaBasedCodec;
import org.opensearch.index.engine.CombinedDeletionPolicy;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.IndexWriterFactory;
import org.opensearch.index.engine.PrunePostingsMergePolicy;
import org.opensearch.index.engine.RecoverySourcePruneMergePolicy;
import org.opensearch.index.engine.ShuffleForcedMergePolicy;
import org.opensearch.index.engine.SoftDeletesPolicy;
import org.opensearch.index.shard.OpenSearchMergePolicy;

public class NativeLuceneIndexWriterFactory
implements IndexWriterFactory {
    @Override
    public IndexWriter createWriter(Directory directory, IndexWriterConfig config) throws IOException {
        if (Assertions.ENABLED) {
            return new AssertingIndexWriter(directory, config);
        }
        return new IndexWriter(directory, config);
    }

    @Override
    public IndexWriter createWriter(Directory directory, MergeScheduler mergeScheduler, Boolean commitOnClose, IndexWriterConfig.OpenMode openMode, CombinedDeletionPolicy deletionPolicy, SoftDeletesPolicy softDeletesPolicy, EngineConfig engineConfig, Logger logger, String associatedCriteria) throws IOException {
        IndexWriterConfig config = IndexWriterConfigBuilder.builder().mergeScheduler(mergeScheduler).commitOnClose(commitOnClose).openMode(openMode).deletionPolicy(deletionPolicy).softDeletesPolicy(softDeletesPolicy).engineConfig(engineConfig).logger(logger).associatedCriteria(associatedCriteria).buildIndexWriterConfig();
        return this.createWriter(directory, config);
    }

    private static class AssertingIndexWriter
    extends IndexWriter {
        AssertingIndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
            super(d, conf);
        }

        public long updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) {
            throw new AssertionError((Object)"must not hard update documents");
        }

        public long tryDeleteDocument(IndexReader readerIn, int docID) {
            assert (false) : "#tryDeleteDocument is not supported. See Lucene#DirectoryReaderWithAllLiveDocs";
            throw new UnsupportedOperationException();
        }
    }

    public static final class IndexWriterConfigBuilder {
        private MergeScheduler mergeScheduler;
        private Boolean commitOnClose;
        private IndexWriterConfig.OpenMode openMode;
        private CombinedDeletionPolicy deletionPolicy;
        private SoftDeletesPolicy softDeletesPolicy;
        private EngineConfig engineConfig;
        private Logger logger;
        private String associatedCriteria;

        private IndexWriterConfigBuilder() {
        }

        public static IndexWriterConfigBuilder builder() {
            return new IndexWriterConfigBuilder();
        }

        public IndexWriterConfigBuilder mergeScheduler(MergeScheduler mergeScheduler) {
            this.mergeScheduler = mergeScheduler;
            return this;
        }

        public IndexWriterConfigBuilder commitOnClose(Boolean commitOnClose) {
            this.commitOnClose = commitOnClose;
            return this;
        }

        public IndexWriterConfigBuilder openMode(IndexWriterConfig.OpenMode openMode) {
            this.openMode = openMode;
            return this;
        }

        public IndexWriterConfigBuilder deletionPolicy(CombinedDeletionPolicy deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
            return this;
        }

        public IndexWriterConfigBuilder softDeletesPolicy(SoftDeletesPolicy softDeletesPolicy) {
            this.softDeletesPolicy = softDeletesPolicy;
            return this;
        }

        public IndexWriterConfigBuilder engineConfig(EngineConfig engineConfig) {
            this.engineConfig = engineConfig;
            return this;
        }

        public IndexWriterConfigBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public IndexWriterConfigBuilder associatedCriteria(String associatedCriteria) {
            this.associatedCriteria = associatedCriteria;
            return this;
        }

        public IndexWriterConfig buildIndexWriterConfig() {
            IndexSettings indexSettings;
            IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
            iwc.setCommitOnClose(this.commitOnClose.booleanValue());
            iwc.setOpenMode(this.openMode);
            if (this.openMode == IndexWriterConfig.OpenMode.CREATE) {
                iwc.setIndexCreatedVersionMajor(this.engineConfig.getIndexSettings().getIndexVersionCreated().luceneVersion.major);
            }
            if (this.deletionPolicy != null) {
                iwc.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            }
            boolean verbose = false;
            try {
                verbose = Boolean.parseBoolean(System.getProperty("tests.verbose"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            iwc.setInfoStream((InfoStream)(verbose ? InfoStream.getDefault() : new LoggerInfoStream(this.logger)));
            iwc.setMergeScheduler(this.mergeScheduler);
            Object mergePolicy = this.engineConfig.getMergePolicy();
            iwc.setSoftDeletesField("__soft_deletes");
            mergePolicy = new RecoverySourcePruneMergePolicy("_recovery_source", this.softDeletesPolicy::getRetentionQuery, (MergePolicy)new SoftDeletesRetentionMergePolicy("__soft_deletes", this.softDeletesPolicy::getRetentionQuery, (MergePolicy)new PrunePostingsMergePolicy((MergePolicy)mergePolicy, "_id")));
            boolean shuffleForcedMerge = Booleans.parseBoolean((String)System.getProperty("opensearch.shuffle_forced_merge", Boolean.TRUE.toString()));
            if (shuffleForcedMerge) {
                mergePolicy = new ShuffleForcedMergePolicy((MergePolicy)mergePolicy);
            }
            if (this.engineConfig.getIndexSettings().isMergeOnFlushEnabled()) {
                long maxFullFlushMergeWaitMillis = this.engineConfig.getIndexSettings().getMaxFullFlushMergeWaitTime().millis();
                if (maxFullFlushMergeWaitMillis > 0L) {
                    iwc.setMaxFullFlushMergeWaitMillis(maxFullFlushMergeWaitMillis);
                    Optional<UnaryOperator<MergePolicy>> mergeOnFlushPolicy = this.engineConfig.getIndexSettings().getMergeOnFlushPolicy();
                    if (mergeOnFlushPolicy.isPresent()) {
                        mergePolicy = (MergePolicy)mergeOnFlushPolicy.get().apply((MergePolicy)mergePolicy);
                    }
                }
            } else {
                iwc.setMaxFullFlushMergeWaitMillis(0L);
            }
            iwc.setCheckPendingFlushUpdate(this.engineConfig.getIndexSettings().isCheckPendingFlushEnabled());
            iwc.setMergePolicy((MergePolicy)new OpenSearchMergePolicy((MergePolicy)mergePolicy));
            iwc.setSimilarity(this.engineConfig.getSimilarity());
            iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().getMbFrac());
            if (this.engineConfig.getIndexSettings().isContextAwareEnabled()) {
                iwc.setCodec((Codec)new CriteriaBasedCodec(this.engineConfig.getCodec(), this.associatedCriteria));
            } else {
                iwc.setCodec(this.engineConfig.getCodec());
            }
            iwc.setUseCompoundFile(this.engineConfig.useCompoundFile());
            if (this.engineConfig.getIndexSort() != null) {
                iwc.setIndexSort(this.engineConfig.getIndexSort());
                if (this.engineConfig.getIndexSettings().getIndexVersionCreated().onOrAfter(Version.V_3_2_0)) {
                    iwc.setParentField("__nested_parent");
                }
            }
            if (this.engineConfig.getLeafSorter() != null) {
                iwc.setLeafSorter(this.engineConfig.getLeafSorter());
            }
            if (!(indexSettings = this.engineConfig.getIndexSettings()).isDocumentReplication() && (indexSettings.isSegRepLocalEnabled() || indexSettings.isRemoteStoreEnabled())) {
                assert (null != this.engineConfig.getIndexReaderWarmer());
                iwc.setMergedSegmentWarmer(this.engineConfig.getIndexReaderWarmer());
            }
            return iwc;
        }
    }
}

