/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import org.opensearch.client.json.DelegatingDeserializer;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;

public class BuildFunctionDeserializer<B, T>
extends DelegatingDeserializer<T, B> {
    private final JsonpDeserializer<B> builderDeserializer;
    private final Function<B, T> build;

    public BuildFunctionDeserializer(JsonpDeserializer<B> builderDeserializer, Function<B, T> build) {
        this.builderDeserializer = builderDeserializer;
        this.build = build;
    }

    @Override
    protected JsonpDeserializer<B> unwrap() {
        return this.builderDeserializer;
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper) {
        B builder = this.builderDeserializer.deserialize(parser, mapper);
        return this.build.apply(builder);
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        B builder = this.builderDeserializer.deserialize(parser, mapper, event);
        return this.build.apply(builder);
    }
}

