/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.GeoPolygonPoints;
import org.opensearch.client.opensearch._types.query_dsl.GeoValidationMethod;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoPolygonQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, GeoPolygonQuery> {
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nonnull
    private final GeoPolygonPoints polygon;
    @Nullable
    private final GeoValidationMethod validationMethod;
    public static final JsonpDeserializer<GeoPolygonQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoPolygonQuery::setupGeoPolygonQueryDeserializer);

    private GeoPolygonQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.polygon = ApiTypeHelper.requireNonNull(builder.polygon, this, "polygon");
        this.validationMethod = builder.validationMethod;
    }

    public static GeoPolygonQuery of(Function<Builder, ObjectBuilder<GeoPolygonQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoPolygon;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nonnull
    public final GeoPolygonPoints polygon() {
        return this.polygon;
    }

    @Nullable
    public final GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey(this.field);
        this.polygon.serialize(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoPolygonQueryDeserializer(ObjectDeserializer<Builder> op) {
        GeoPolygonQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.polygon(GeoPolygonPoints._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreUnmapped);
        result = 31 * result + this.polygon.hashCode();
        result = 31 * result + Objects.hashCode(this.validationMethod);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPolygonQuery other = (GeoPolygonQuery)o;
        return this.field.equals(other.field) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && this.polygon.equals(other.polygon) && Objects.equals(this.validationMethod, other.validationMethod);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoPolygonQuery> {
        private String field;
        @Nullable
        private Boolean ignoreUnmapped;
        private GeoPolygonPoints polygon;
        @Nullable
        private GeoValidationMethod validationMethod;

        public Builder() {
        }

        private Builder(GeoPolygonQuery o) {
            super(o);
            this.field = o.field;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.polygon = o.polygon;
            this.validationMethod = o.validationMethod;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.polygon = o.polygon;
            this.validationMethod = o.validationMethod;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Nonnull
        public final Builder polygon(GeoPolygonPoints value) {
            this.polygon = value;
            return this;
        }

        @Nonnull
        public final Builder polygon(Function<GeoPolygonPoints.Builder, ObjectBuilder<GeoPolygonPoints>> fn) {
            return this.polygon(fn.apply(new GeoPolygonPoints.Builder()).build());
        }

        @Nonnull
        public final Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoPolygonQuery build() {
            this._checkSingleUse();
            return new GeoPolygonQuery(this);
        }
    }
}

