/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.ByteBuffer;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamBase;
import software.amazon.awssdk.crt.http.HttpStreamBaseResponseHandler;
import software.amazon.awssdk.crt.http.HttpStreamMetrics;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;

class HttpStreamResponseHandlerNativeAdapter {
    private HttpStreamResponseHandler responseHandler;
    private HttpStreamBaseResponseHandler responseBaseHandler;

    HttpStreamResponseHandlerNativeAdapter(HttpStreamResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        this.responseBaseHandler = null;
    }

    HttpStreamResponseHandlerNativeAdapter(HttpStreamBaseResponseHandler responseBaseHandler) {
        this.responseBaseHandler = responseBaseHandler;
        this.responseHandler = null;
    }

    void onResponseHeaders(HttpStreamBase stream, int responseStatusCode, int blockType, ByteBuffer headersBlob) {
        HttpHeader[] headersArray = HttpHeader.loadHeadersFromMarshalledHeadersBlob(headersBlob);
        if (this.responseBaseHandler != null) {
            this.responseBaseHandler.onResponseHeaders(stream, responseStatusCode, blockType, headersArray);
        } else {
            this.responseHandler.onResponseHeaders((HttpStream)stream, responseStatusCode, blockType, headersArray);
        }
    }

    void onResponseHeadersDone(HttpStreamBase stream, int blockType) {
        if (this.responseBaseHandler != null) {
            this.responseBaseHandler.onResponseHeadersDone(stream, blockType);
        } else {
            this.responseHandler.onResponseHeadersDone((HttpStream)stream, blockType);
        }
    }

    int onResponseBody(HttpStreamBase stream, ByteBuffer bodyBytesIn) {
        byte[] body = new byte[bodyBytesIn.limit()];
        bodyBytesIn.get(body);
        if (this.responseBaseHandler != null) {
            return this.responseBaseHandler.onResponseBody(stream, body);
        }
        return this.responseHandler.onResponseBody((HttpStream)stream, body);
    }

    void onMetrics(HttpStreamBase stream, HttpStreamMetrics metrics) {
        if (this.responseBaseHandler != null) {
            this.responseBaseHandler.onMetrics(stream, metrics);
        } else {
            this.responseHandler.onMetrics((HttpStream)stream, metrics);
        }
    }

    void onResponseComplete(HttpStreamBase stream, int errorCode) {
        if (this.responseBaseHandler != null) {
            this.responseBaseHandler.onResponseComplete(stream, errorCode);
        } else {
            this.responseHandler.onResponseComplete((HttpStream)stream, errorCode);
        }
    }
}

