/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.Objects;

final class Throughput {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private final long numBytes;
    private final Duration duration;
    private final double bytesPerSecond;

    private Throughput(long numBytes, Duration duration) {
        this.numBytes = numBytes;
        this.duration = duration;
        this.bytesPerSecond = (double)numBytes / ((double)duration.toNanos() / 1.0E9);
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public double toBps() {
        return this.bytesPerSecond;
    }

    public Throughput plus(Throughput other) {
        return new Throughput(this.numBytes + other.numBytes, this.duration.plus(other.duration));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Throughput)) {
            return false;
        }
        Throughput that = (Throughput)o;
        return Double.compare(that.bytesPerSecond, this.bytesPerSecond) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.bytesPerSecond);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bytesPerSecond", this.bytesPerSecond).toString();
    }

    public static Throughput zero() {
        return new Throughput(0L, Duration.ZERO);
    }

    public static Throughput of(long numBytes, Duration duration) {
        return new Throughput(numBytes, duration);
    }

    public static Throughput bytesPerSecond(long numBytes) {
        return new Throughput(numBytes, Duration.ofSeconds(1L));
    }
}

