﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastService_EXPORTS.h>
#include <aws/forecast/model/DataDestination.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {

/**
 * <p>Provides a summary of the forecast export job properties used in the
 * <a>ListForecastExportJobs</a> operation. To get the complete set of properties,
 * call the <a>DescribeForecastExportJob</a> operation, and provide the listed
 * <code>ForecastExportJobArn</code>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ForecastExportJobSummary">AWS
 * API Reference</a></p>
 */
class ForecastExportJobSummary {
 public:
  AWS_FORECASTSERVICE_API ForecastExportJobSummary() = default;
  AWS_FORECASTSERVICE_API ForecastExportJobSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_FORECASTSERVICE_API ForecastExportJobSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FORECASTSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the forecast export job.</p>
   */
  inline const Aws::String& GetForecastExportJobArn() const { return m_forecastExportJobArn; }
  inline bool ForecastExportJobArnHasBeenSet() const { return m_forecastExportJobArnHasBeenSet; }
  template <typename ForecastExportJobArnT = Aws::String>
  void SetForecastExportJobArn(ForecastExportJobArnT&& value) {
    m_forecastExportJobArnHasBeenSet = true;
    m_forecastExportJobArn = std::forward<ForecastExportJobArnT>(value);
  }
  template <typename ForecastExportJobArnT = Aws::String>
  ForecastExportJobSummary& WithForecastExportJobArn(ForecastExportJobArnT&& value) {
    SetForecastExportJobArn(std::forward<ForecastExportJobArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the forecast export job.</p>
   */
  inline const Aws::String& GetForecastExportJobName() const { return m_forecastExportJobName; }
  inline bool ForecastExportJobNameHasBeenSet() const { return m_forecastExportJobNameHasBeenSet; }
  template <typename ForecastExportJobNameT = Aws::String>
  void SetForecastExportJobName(ForecastExportJobNameT&& value) {
    m_forecastExportJobNameHasBeenSet = true;
    m_forecastExportJobName = std::forward<ForecastExportJobNameT>(value);
  }
  template <typename ForecastExportJobNameT = Aws::String>
  ForecastExportJobSummary& WithForecastExportJobName(ForecastExportJobNameT&& value) {
    SetForecastExportJobName(std::forward<ForecastExportJobNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the
   * forecast is exported.</p>
   */
  inline const DataDestination& GetDestination() const { return m_destination; }
  inline bool DestinationHasBeenSet() const { return m_destinationHasBeenSet; }
  template <typename DestinationT = DataDestination>
  void SetDestination(DestinationT&& value) {
    m_destinationHasBeenSet = true;
    m_destination = std::forward<DestinationT>(value);
  }
  template <typename DestinationT = DataDestination>
  ForecastExportJobSummary& WithDestination(DestinationT&& value) {
    SetDestination(std::forward<DestinationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the forecast export job. States include:</p> <ul> <li> <p>
   * <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>,
   * <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p>
   * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li> <li> <p>
   * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
   * <code>DELETE_FAILED</code> </p> </li> </ul>  <p>The <code>Status</code> of
   * the forecast export job must be <code>ACTIVE</code> before you can access the
   * forecast in your S3 bucket.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  ForecastExportJobSummary& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If an error occurred, an informational message about the error.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  ForecastExportJobSummary& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the forecast export job was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  ForecastExportJobSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The last time the resource was modified. The timestamp depends on the status
   * of the job:</p> <ul> <li> <p> <code>CREATE_PENDING</code> - The
   * <code>CreationTime</code>.</p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> -
   * The current timestamp.</p> </li> <li> <p> <code>CREATE_STOPPING</code> - The
   * current timestamp.</p> </li> <li> <p> <code>CREATE_STOPPED</code> - When the job
   * stopped.</p> </li> <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> -
   * When the job finished or failed.</p> </li> </ul>
   */
  inline const Aws::Utils::DateTime& GetLastModificationTime() const { return m_lastModificationTime; }
  inline bool LastModificationTimeHasBeenSet() const { return m_lastModificationTimeHasBeenSet; }
  template <typename LastModificationTimeT = Aws::Utils::DateTime>
  void SetLastModificationTime(LastModificationTimeT&& value) {
    m_lastModificationTimeHasBeenSet = true;
    m_lastModificationTime = std::forward<LastModificationTimeT>(value);
  }
  template <typename LastModificationTimeT = Aws::Utils::DateTime>
  ForecastExportJobSummary& WithLastModificationTime(LastModificationTimeT&& value) {
    SetLastModificationTime(std::forward<LastModificationTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_forecastExportJobArn;

  Aws::String m_forecastExportJobName;

  DataDestination m_destination;

  Aws::String m_status;

  Aws::String m_message;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastModificationTime{};
  bool m_forecastExportJobArnHasBeenSet = false;
  bool m_forecastExportJobNameHasBeenSet = false;
  bool m_destinationHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_messageHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastModificationTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
