﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {

/**
 * <p>A trust store that can be associated with a web portal. A trust store
 * contains certificate authority (CA) certificates. Once associated with a web
 * portal, the browser in a streaming session will recognize certificates that have
 * been issued using any of the CAs in the trust store. If your organization has
 * internal websites that use certificates issued by private CAs, you should add
 * the private CA certificate to the trust store. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TrustStore">AWS
 * API Reference</a></p>
 */
class TrustStore {
 public:
  AWS_WORKSPACESWEB_API TrustStore() = default;
  AWS_WORKSPACESWEB_API TrustStore(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESWEB_API TrustStore& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESWEB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A list of web portal ARNs that this trust store is associated with.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAssociatedPortalArns() const { return m_associatedPortalArns; }
  inline bool AssociatedPortalArnsHasBeenSet() const { return m_associatedPortalArnsHasBeenSet; }
  template <typename AssociatedPortalArnsT = Aws::Vector<Aws::String>>
  void SetAssociatedPortalArns(AssociatedPortalArnsT&& value) {
    m_associatedPortalArnsHasBeenSet = true;
    m_associatedPortalArns = std::forward<AssociatedPortalArnsT>(value);
  }
  template <typename AssociatedPortalArnsT = Aws::Vector<Aws::String>>
  TrustStore& WithAssociatedPortalArns(AssociatedPortalArnsT&& value) {
    SetAssociatedPortalArns(std::forward<AssociatedPortalArnsT>(value));
    return *this;
  }
  template <typename AssociatedPortalArnsT = Aws::String>
  TrustStore& AddAssociatedPortalArns(AssociatedPortalArnsT&& value) {
    m_associatedPortalArnsHasBeenSet = true;
    m_associatedPortalArns.emplace_back(std::forward<AssociatedPortalArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the trust store.</p>
   */
  inline const Aws::String& GetTrustStoreArn() const { return m_trustStoreArn; }
  inline bool TrustStoreArnHasBeenSet() const { return m_trustStoreArnHasBeenSet; }
  template <typename TrustStoreArnT = Aws::String>
  void SetTrustStoreArn(TrustStoreArnT&& value) {
    m_trustStoreArnHasBeenSet = true;
    m_trustStoreArn = std::forward<TrustStoreArnT>(value);
  }
  template <typename TrustStoreArnT = Aws::String>
  TrustStore& WithTrustStoreArn(TrustStoreArnT&& value) {
    SetTrustStoreArn(std::forward<TrustStoreArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_associatedPortalArns;

  Aws::String m_trustStoreArn;
  bool m_associatedPortalArnsHasBeenSet = false;
  bool m_trustStoreArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
