/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplateStore;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesRegistry;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;

public class PrefPageSQLTemplates
extends TemplatePreferencePage
implements IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.templates";
    private static final int BTN_IDX_EXPORT = 0;
    private static final int BTN_IDX_IMPORT = 1;
    private static final int BTN_IDX_REVERT = 2;
    private static final int BTN_IDX_RESTORE = 3;
    private static final int BTN_IDX_REMOVE = 4;
    private static final int BTN_IDX_EDIT = 5;
    private static final int BTN_IDX_NEW = 6;
    private final List<Button> buttons = new ArrayList<Button>();
    private Table table;
    private final SQLTemplateStore templateStore;

    public PrefPageSQLTemplates() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
        this.templateStore = SQLTemplatesRegistry.getInstance().getTemplateStore();
        this.setTemplateStore(this.templateStore);
        this.setContextTypeRegistry(SQLTemplatesRegistry.getInstance().getTemplateContextRegistry());
    }

    protected Control createContents(Composite ancestor) {
        Control root = super.createContents(ancestor);
        this.buttons.clear();
        Stack<Control> stack = new Stack<Control>();
        stack.add(root);
        while (stack.size() > 0) {
            Control ctl = (Control)stack.pop();
            if (ctl instanceof Button) {
                Button btn = (Button)ctl;
                if ((btn.getStyle() & 8) == 0) continue;
                this.buttons.add(btn);
                btn.setEnabled(false);
                continue;
            }
            if (ctl instanceof Table) {
                this.table = (Table)ctl;
                continue;
            }
            if (!(ctl instanceof Composite)) continue;
            Control[] controlArray = ((Composite)ctl).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cctl = controlArray[n2];
                stack.push(cctl);
                ++n2;
            }
        }
        return root;
    }

    protected void updateButtons() {
        if (this.buttons.size() > 0) {
            boolean editAllowed = DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
            this.buttons.get(1).setEnabled(editAllowed);
            this.buttons.get(6).setEnabled(editAllowed);
            Set<String> customTemplateNames = this.templateStore.getCustomTemplateNames();
            TableItem[] selection = this.table.getSelection();
            int selectionCount = selection.length;
            List items = Stream.of(selection).map(t -> (TemplatePersistenceData)t.getData()).collect(Collectors.toList());
            boolean canRevert = items.stream().anyMatch(TemplatePersistenceData::isModified);
            int itemCount = this.table.getItemCount();
            boolean canRestore = this.templateStore.getTemplateData(true).length != this.templateStore.getTemplateData(false).length;
            this.buttons.get(5).setEnabled(selectionCount == 1 && (editAllowed || !customTemplateNames.contains(((TemplatePersistenceData)items.get(0)).getTemplate().getName())));
            this.buttons.get(0).setEnabled(selectionCount > 0);
            this.buttons.get(4).setEnabled(selectionCount > 0 && selectionCount <= itemCount && (editAllowed || items.stream().noneMatch(t -> customTemplateNames.contains(t.getTemplate().getName()))));
            this.buttons.get(3).setEnabled(canRestore);
            this.buttons.get(2).setEnabled(canRevert);
        } else {
            super.updateButtons();
        }
    }

    @Nullable
    protected Template editTemplate(@NotNull Template template, boolean edit, boolean isNameModifiable) {
        boolean editAllowed = DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
        boolean isCustomTemplate = this.templateStore.getCustomTemplateNames().contains(template.getName());
        if (editAllowed || !isCustomTemplate) {
            return super.editTemplate(template, edit, isNameModifiable);
        }
        return null;
    }

    protected String getFormatterPreferenceKey() {
        return "org.jkiss.dbeaver.core.sql_templates";
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

