/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleSequence;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.ext.oracle.ui.actions.OracleCompilerDialog;
import org.jkiss.dbeaver.ext.oracle.ui.actions.OracleTaskHandler;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLogBase;
import org.jkiss.dbeaver.model.exec.compile.DBCSourceHost;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class CompileHandler
extends OracleTaskHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activePart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        List<OracleSourceObject> objects = this.getSelectedObjects(event);
        if (!objects.isEmpty()) {
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            if (objects.size() == 1) {
                OracleSourceObject unit = objects.get(0);
                DBCSourceHost sourceHost = null;
                if (activePart != null && (sourceHost = (DBCSourceHost)RuntimeUtils.getObjectAdapter((Object)activePart, DBCSourceHost.class)) == null) {
                    sourceHost = (DBCSourceHost)activePart.getAdapter(DBCSourceHost.class);
                }
                if (sourceHost != null && sourceHost.getSourceObject() != unit) {
                    sourceHost = null;
                }
                DBCCompileLogBase compileLog = sourceHost == null ? new DBCCompileLogBase() : sourceHost.getCompileLog();
                compileLog.clearLog();
                Throwable error = null;
                try {
                    UIUtils.runInProgressService(arg_0 -> CompileHandler.lambda$0((DBCCompileLog)compileLog, unit, arg_0));
                    if (compileLog.getError() != null) {
                        error = compileLog.getError();
                    }
                }
                catch (InvocationTargetException e) {
                    error = e.getTargetException();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                if (error != null) {
                    DBWorkbench.getPlatformUI().showError("Unexpected compilation error", null, error);
                } else if (!CommonUtils.isEmpty((Collection)compileLog.getErrorStack())) {
                    int line = -1;
                    int position = -1;
                    StringBuilder fullMessage = new StringBuilder();
                    for (DBCCompileError oce : compileLog.getErrorStack()) {
                        fullMessage.append(oce.toString()).append(GeneralUtils.getDefaultLineSeparator());
                        if (line >= 0) continue;
                        line = oce.getLine();
                        position = oce.getPosition();
                    }
                    if (sourceHost != null && sourceHost.getSourceObject() == unit && line > 0 && position >= 0) {
                        sourceHost.positionSource(line, position);
                        activePart.getSite().getPage().activate((IWorkbenchPart)activePart);
                    }
                    String errorTitle = unit.getName() + " compilation failed";
                    if (sourceHost != null) {
                        sourceHost.setCompileInfo(errorTitle, true);
                        sourceHost.showCompileLog();
                    }
                    DBWorkbench.getPlatformUI().showError(errorTitle, fullMessage.toString());
                } else {
                    String message = unit.getName() + " compiled successfully";
                    if (sourceHost != null) {
                        sourceHost.setCompileInfo(message, true);
                    }
                    UIUtils.showMessageBox((Shell)activeShell, (String)"Done", (String)message, (int)2);
                }
            } else {
                OracleCompilerDialog dialog = new OracleCompilerDialog(activeShell, objects);
                dialog.open();
            }
        }
        return null;
    }

    private List<OracleSourceObject> getSelectedObjects(ExecutionEvent event) {
        DBSObject dbsObject;
        IWorkbenchPart activePart;
        ArrayList<OracleSourceObject> objects = new ArrayList<OracleSourceObject>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            for (Object element : (IStructuredSelection)currentSelection) {
                OracleSourceObject sourceObject = (OracleSourceObject)RuntimeUtils.getObjectAdapter(element, OracleSourceObject.class);
                if (sourceObject == null) continue;
                objects.add(sourceObject);
            }
        }
        if (objects.isEmpty() && (activePart = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof IEditorPart && ((IEditorPart)activePart).getEditorInput() instanceof IDatabaseEditorInput && (dbsObject = ((IDatabaseEditorInput)((IEditorPart)activePart).getEditorInput()).getDatabaseObject()) instanceof OracleSourceObject) {
            objects.add((OracleSourceObject)dbsObject);
        }
        return objects;
    }

    public void updateElement(UIElement element, Map parameters) {
        List<OracleSourceObject> objects = this.getOracleSourceObjects(element);
        if (!objects.isEmpty()) {
            if (objects.size() > 1) {
                element.setText("Compile " + objects.size() + " objects");
            } else {
                OracleSourceObject sourceObject = objects.get(0);
                String objectType = OracleUtils.formatWord((String)sourceObject.getSourceType().name());
                element.setText("Compile " + objectType);
            }
        }
    }

    public static boolean compileUnit(DBRProgressMonitor monitor, DBCCompileLog compileLog, OracleSourceObject unit) throws DBException {
        Object[] compileActions = unit.getCompileActions(monitor);
        if (ArrayUtils.isEmpty((Object[])compileActions)) {
            if (unit instanceof OracleSequence) {
                return false;
            }
            throw new DBCException("No compile actions associated with " + unit.getSourceType().name());
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)unit, (String)("Compile '" + unit.getName() + "'"));){
            boolean success = true;
            Object[] objectArray = compileActions;
            int n = compileActions.length;
            int n2 = 0;
            while (n2 < n) {
                Object action = objectArray[n2];
                String script = action.getScript();
                compileLog.trace(script);
                if (monitor.isCanceled()) break;
                try {
                    Throwable throwable2 = null;
                    Object var14_18 = null;
                    try (JDBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, script, false, false, false);){
                        action.beforeExecute((DBCSession)session);
                        dbStat.executeStatement();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    action.afterExecute((DBCSession)session, null);
                }
                catch (DBCException e) {
                    action.afterExecute((DBCSession)session, (Throwable)e);
                    throw e;
                }
                if (action instanceof OracleObjectPersistAction && !CompileHandler.logObjectErrors(session, compileLog, (OracleStatefulObject)unit, ((OracleObjectPersistAction)action).getObjectType())) {
                    success = false;
                }
                ++n2;
            }
            DBSObjectState oldState = unit.getObjectState();
            unit.refreshObjectState(monitor);
            if (unit.getObjectState() != oldState) {
                unit.getDataSource().getContainer().fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)unit));
            }
            return success;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$0(DBCCompileLog dBCCompileLog, OracleSourceObject oracleSourceObject, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Compile", 1);
        try {
            try {
                CompileHandler.compileUnit(monitor, dBCCompileLog, oracleSourceObject);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

