/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum SQLTableAliasInsertMode {
    NONE("N/A"),
    PLAIN("my_table mt"),
    EXTENDED("my_table AS mt");

    private final String text;

    private SQLTableAliasInsertMode(String text) {
        this.text = text;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public static SQLTableAliasInsertMode fromPreferences(@NotNull DBPPreferenceStore preferenceStore) {
        String prop = preferenceStore.getString("sql.proposals.insert.table.alias");
        if ("true".equals(prop)) {
            return PLAIN;
        }
        if ("false".equals(prop)) {
            return NONE;
        }
        return (SQLTableAliasInsertMode)CommonUtils.valueOf(SQLTableAliasInsertMode.class, (String)prop, (Enum)PLAIN);
    }
}

