/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.clickhouse.ClickhouseDataSourceInfo;
import org.jkiss.dbeaver.ext.clickhouse.ClickhouseTypeParser;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseSQLDialect;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTableEngine;
import org.jkiss.dbeaver.ext.clickhouse.model.jdbc.ClickhouseJdbcFactory;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class ClickhouseDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(ClickhouseDataSource.class);
    private static Map<String, String> dataTypeMap = new HashMap<String, String>();
    private final TableEnginesCache engineCache = new TableEnginesCache();

    static {
        dataTypeMap.put(String.class.getName(), "String");
        dataTypeMap.put(Integer.class.getName(), "Int32");
        dataTypeMap.put(Long.class.getName(), "Int64");
        dataTypeMap.put(Short.class.getName(), "Int16");
        dataTypeMap.put(Byte.class.getName(), "Int8");
        dataTypeMap.put(Float.class.getName(), "Float32");
        dataTypeMap.put(Double.class.getName(), "Float64");
        dataTypeMap.put(Date.class.getName(), "DateTime");
    }

    public ClickhouseDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new ClickhouseSQLDialect());
        this.engineCache.getAllObjects(monitor, (DBSObject)this);
    }

    List<ClickhouseTableEngine> getTableEngines() {
        return this.engineCache.getCachedObjects();
    }

    ClickhouseTableEngine getEngineByName(@NotNull String engineName) {
        return (ClickhouseTableEngine)this.engineCache.getCachedObject(engineName);
    }

    @NotNull
    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        DBWHandlerConfiguration sslConfig;
        Properties properties = super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        if (!CommonUtils.toBoolean((Object)properties.getProperty("use_server_time_zone")) && !CommonUtils.toBoolean((Object)properties.getProperty("use_time_zone"))) {
            DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            String customTimeZone = preferenceStore.getString("java.client.timezone");
            if (customTimeZone.equals("Default")) {
                customTimeZone = TimeZone.getDefault().getID();
            }
            properties.put("use_time_zone", customTimeZone);
        }
        if ((sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("clickhouse-ssl")) != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(monitor, properties, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        }
        this.configureSession(properties);
        return properties;
    }

    private void initSSL(DBRProgressMonitor monitor, Properties properties, DBWHandlerConfiguration sslConfig) throws DBException {
        monitor.subTask("Initialising SSL configuration");
        properties.put("ssl", "true");
        try {
            if ("com_clickhouse".equals(this.getContainer().getDriver().getId())) {
                if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                    String clientKeyProp;
                    String clientCertProp = sslConfig.getSecureProperty("ssl.client.cert.value");
                    if (!CommonUtils.isEmpty((String)clientCertProp)) {
                        properties.put("sslcert", this.saveCertificateToFile(clientCertProp));
                    }
                    if (!CommonUtils.isEmpty((String)(clientKeyProp = sslConfig.getSecureProperty("ssl.client.key.value")))) {
                        properties.put("sslkey", this.saveCertificateToFile(clientKeyProp));
                    }
                } else {
                    properties.put("sslcert", sslConfig.getStringProperty("ssl.client.cert"));
                    properties.put("sslkey", sslConfig.getStringProperty("ssl.client.key"));
                }
                properties.put("sslmode", sslConfig.getStringProperty("ssl.mode"));
            } else {
                String mode = sslConfig.getStringProperty("ssl.mode");
                if (mode != null) {
                    properties.put("sslmode", mode.toLowerCase());
                }
            }
            if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                String caCertProp = sslConfig.getSecureProperty("ssl.ca.cert.value");
                if (!CommonUtils.isEmpty((String)caCertProp)) {
                    properties.put("sslrootcert", this.saveCertificateToFile(caCertProp));
                }
            } else {
                properties.put("sslrootcert", sslConfig.getStringProperty("ssl.ca.cert"));
            }
        }
        catch (IOException e) {
            throw new DBException("Can not configure SSL", (Throwable)e);
        }
    }

    private void configureSession(@NotNull Properties properties) {
        properties.put("clickhouse_setting_session_id", "sess_" + String.valueOf(UUID.randomUUID()));
    }

    public void cancelStatementExecute(DBRProgressMonitor monitor, JDBCStatement statement) throws DBException {
        block2: {
            try {
                super.cancelStatementExecute(monitor, statement);
            }
            catch (Throwable ex) {
                if (!ex.getMessage().contains("Code: 373")) break block2;
                this.fallbackForServerID(monitor, statement);
            }
        }
    }

    protected void fallbackForServerID(@NotNull DBRProgressMonitor monitor, @NotNull JDBCStatement statement) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.openConnection(monitor, statement.getConnection().getExecutionContext(), "Close Query");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (Statement dbStat = connection.createStatement();){
                    Statement original = ((JDBCStatementImpl)statement).getOriginal();
                    String getLastQueryId = (String)BeanUtils.invokeObjectDeclaredMethod((Object)original, (String)"getLastQueryId", (Class[])new Class[0], (Object[])new Object[0]);
                    dbStat.execute("KILL QUERY WHERE query_id='%s'".formatted(getLastQueryId));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new DBCException("Error during cancelling query", e);
        }
    }

    protected synchronized void readDatabaseServerVersion(Connection session, DatabaseMetaData metaData) {
        if (this.databaseVersion == null) {
            try {
                String version = (String)JDBCUtils.executeQuery((Connection)session, (String)"SELECT VERSION()", (Object[])new Object[0]);
                if (version != null) {
                    this.databaseVersion = new Version(version);
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error determining server version", e);
            }
            if (this.databaseVersion == null) {
                super.readDatabaseServerVersion(session, metaData);
            }
        }
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        DBSDataType type;
        String shortName = dataTypeMap.get(typeFullName);
        if (shortName != null) {
            typeFullName = shortName;
        }
        if (ClickhouseTypeParser.isComplexType(typeFullName) && (type = ClickhouseTypeParser.getType(monitor, this, typeFullName)) != null) {
            return type;
        }
        type = super.resolveDataType(monitor, typeFullName);
        if (type != null) {
            return type;
        }
        String baseTypeName = ClickhouseTypeParser.getTypeNameWithoutModifiers(typeFullName);
        return super.resolveDataType(monitor, baseTypeName);
    }

    @NotNull
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case STRING: {
                return "String";
            }
        }
        return super.getDefaultDataTypeName(dataKind);
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new ClickhouseDataSourceInfo(metaData);
    }

    /*
     * Exception decompiling
     */
    public List<String> getCatalogsNames(@NotNull DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData, GenericMetaObject catalogObject, @Nullable DBSObjectFilter catalogFilters) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public JDBCFactory getJdbcFactory() {
        return new ClickhouseJdbcFactory();
    }

    public boolean isOmitCatalog() {
        return this.isDriverVersionAtLeast(0, 8);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        if (typeName.startsWith("Array")) {
            return DBPDataKind.ARRAY;
        }
        if (typeName.startsWith("Tuple")) {
            return DBPDataKind.STRUCT;
        }
        return super.resolveDataKind(typeName, valueType);
    }

    boolean isSupportTableComments() {
        return this.isServerVersionAtLeast(21, 6);
    }

    protected boolean isConnectionReadOnlyBroken() {
        return this.isDriverVersionAtLeast(0, 8);
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection connection = super.openConnection(monitor, context, purpose);
        if (this.getContainer().isConnectionReadOnly() && this.isConnectionReadOnlyBroken()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Statement stmt = connection.createStatement();){
                    stmt.execute("SET readonly=1");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to set readonly mode", (Throwable)e);
            }
        }
        return connection;
    }

    static class TableEnginesCache
    extends JDBCObjectCache<ClickhouseDataSource, ClickhouseTableEngine> {
        TableEnginesCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ClickhouseDataSource clickhouseDataSource) throws SQLException {
            return session.prepareStatement("SELECT name FROM system.table_engines");
        }

        protected void detectCaseSensitivity(DBSObject object) {
            this.setCaseSensitive(true);
        }

        @Nullable
        protected ClickhouseTableEngine fetchObject(@NotNull JDBCSession session, @NotNull ClickhouseDataSource clickhouseDataSource, @NotNull JDBCResultSet dbResult) {
            String engineName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
            if (CommonUtils.isNotEmpty((String)engineName)) {
                return new ClickhouseTableEngine(engineName, clickhouseDataSource);
            }
            return null;
        }
    }
}

