/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.Codegen;

public class ClassCompiler {
    private String mainMethodClassName;
    private CompilerEnvirons compilerEnv;
    private Class<?> targetExtends;
    private Class<?>[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnvirons) {
        if (compilerEnvirons == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnvirons;
        this.mainMethodClassName = "org.mozilla.javascript.optimizer.OptRuntime";
    }

    public void setMainMethodClass(String string) {
        this.mainMethodClassName = string;
    }

    public String getMainMethodClass() {
        return this.mainMethodClassName;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class<?> getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class<?> clazz) {
        this.targetExtends = clazz;
    }

    public Class<?>[] getTargetImplements() {
        return this.targetImplements == null ? null : (Class[])this.targetImplements.clone();
    }

    public void setTargetImplements(Class<?>[] classArray) {
        this.targetImplements = classArray == null ? null : (Class[])classArray.clone();
    }

    protected String makeAuxiliaryClassName(String string, String string2) {
        return string + string2;
    }

    public Object[] compileToClassFiles(String string, String string2, int n, String string3) {
        Parser parser = new Parser(this.compilerEnv);
        AstRoot astRoot = parser.parse(string, string2, n);
        IRFactory iRFactory = new IRFactory(this.compilerEnv);
        ScriptNode scriptNode = iRFactory.transformTree(astRoot);
        iRFactory = null;
        astRoot = null;
        parser = null;
        Class<?> clazz = this.getTargetExtends();
        Class<?>[] classArray = this.getTargetImplements();
        boolean bl = classArray == null && clazz == null;
        String string4 = bl ? string3 : this.makeAuxiliaryClassName(string3, "1");
        Codegen codegen = new Codegen();
        codegen.setMainMethodClass(this.mainMethodClassName);
        byte[] byArray = codegen.compileToClassFile(this.compilerEnv, string4, scriptNode, scriptNode.getEncodedSource(), false);
        if (bl) {
            return new Object[]{string4, byArray};
        }
        int n2 = scriptNode.getFunctionCount();
        ObjToIntMap objToIntMap = new ObjToIntMap(n2);
        for (int i = 0; i != n2; ++i) {
            FunctionNode functionNode = scriptNode.getFunctionNode(i);
            String string5 = functionNode.getName();
            if (string5 == null || string5.length() == 0) continue;
            objToIntMap.put(string5, functionNode.getParamCount());
        }
        if (clazz == null) {
            clazz = ScriptRuntime.ObjectClass;
        }
        byte[] byArray2 = JavaAdapter.createAdapterCode(objToIntMap, string3, clazz, classArray, string4);
        return new Object[]{string3, byArray2, string4, byArray};
    }
}

