/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.values;

import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableLengthValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import org.w3c.css.om.unit.CSSUnit;

public abstract class AnimatableNumericValue
extends AnimatableValue {
    protected short lengthType;
    protected short percentageInterpretation;

    protected AnimatableNumericValue(AnimationTarget target) {
        super(target);
    }

    protected AnimatableNumericValue(AnimationTarget target, short type, short pcInterp) {
        super(target);
        this.lengthType = type;
        this.percentageInterpretation = pcInterp;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableLengthValue res = result == null ? new AnimatableLengthValue(this.target) : (AnimatableLengthValue)result;
        short oldLengthType = res.lengthType;
        float oldLengthValue = res.getLengthValue();
        short oldPercentageInterpretation = res.percentageInterpretation;
        res.lengthType = this.lengthType;
        res.lengthValue = this.getLengthValue();
        res.percentageInterpretation = this.percentageInterpretation;
        if (to != null) {
            float toValue;
            AnimatableNumericValue toLength = (AnimatableNumericValue)to;
            if (!AnimatableNumericValue.compatibleTypes(res.lengthType, res.percentageInterpretation, toLength.lengthType, toLength.percentageInterpretation)) {
                res.lengthValue = this.target.svgToUserSpace(oldLengthValue, res.lengthType, res.percentageInterpretation);
                res.lengthType = 0;
                toValue = toLength.target.svgToUserSpace(toLength.getLengthValue(), toLength.lengthType, toLength.percentageInterpretation);
            } else {
                toValue = toLength.getLengthValue();
            }
            res.lengthValue += interpolation * (toValue - res.getLengthValue());
        }
        if (accumulation != null) {
            float accValue;
            AnimatableNumericValue accLength = (AnimatableNumericValue)accumulation;
            if (!AnimatableNumericValue.compatibleTypes(res.lengthType, res.percentageInterpretation, accLength.lengthType, accLength.percentageInterpretation)) {
                res.lengthValue = this.target.svgToUserSpace(res.getLengthValue(), res.lengthType, res.percentageInterpretation);
                res.lengthType = 0;
                accValue = accLength.target.svgToUserSpace(accLength.getLengthValue(), accLength.lengthType, accLength.percentageInterpretation);
            } else {
                accValue = accLength.getLengthValue();
            }
            res.lengthValue += (float)multiplier * accValue;
        }
        if (oldPercentageInterpretation != res.percentageInterpretation || oldLengthType != res.lengthType || oldLengthValue != res.getLengthValue()) {
            res.hasChanged = true;
        }
        return res;
    }

    public static boolean compatibleTypes(short t1, short pi1, short t2, short pi2) {
        return t1 == t2 && (t1 != 2 || pi1 == pi2) || t1 == 0 && t2 == 3 || t1 == 3 && t2 == 0;
    }

    public int getLengthType() {
        return this.lengthType;
    }

    public abstract float getLengthValue();

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        AnimatableNumericValue o = (AnimatableNumericValue)other;
        float v1 = this.target.svgToUserSpace(this.getLengthValue(), this.lengthType, this.percentageInterpretation);
        float v2 = this.target.svgToUserSpace(o.getLengthValue(), o.lengthType, o.percentageInterpretation);
        return Math.abs(v1 - v2);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableLengthValue(this.target, 0, 0.0f, this.percentageInterpretation);
    }

    @Override
    public String getCssText() {
        return AnimatableNumericValue.formatNumber(this.getLengthValue()) + CSSUnit.dimensionUnitString((short)this.lengthType);
    }
}

