/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.impl;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import java.util.Locale;

public class AttrUtil {
    public static boolean isProxyAttr(LexicalUnit lunit) {
        return AttrUtil.finalAttrType(lunit) == CSSValue.Type.UNKNOWN;
    }

    public static CSSValue.Type finalAttrType(LexicalUnit lunit) {
        LexicalUnit fallback;
        LexicalUnit nextParam = lunit.getParameters();
        if (nextParam == null || nextParam.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            return CSSValue.Type.UNKNOWN;
        }
        if ((nextParam = nextParam.getNextLexicalUnit()) == null) {
            return CSSValue.Type.STRING;
        }
        CSSValueSyntax attrSyntax = null;
        short unit = 1;
        LexicalUnit.LexicalType type = nextParam.getLexicalUnitType();
        if (type != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            switch (type) {
                case IDENT: {
                    String attrUnit = nextParam.getStringValue().toLowerCase(Locale.ROOT);
                    if (!"string".equals(attrUnit)) {
                        unit = UnitStringToId.unitFromString(attrUnit);
                        break;
                    }
                    attrSyntax = SyntaxParser.createSimpleSyntax("string");
                    break;
                }
                case OPERATOR_MOD: {
                    unit = 2;
                    break;
                }
                case TYPE_FUNCTION: {
                    try {
                        attrSyntax = nextParam.getParameters().getSyntax();
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                default: {
                    return CSSValue.Type.UNKNOWN;
                }
            }
            nextParam = nextParam.getNextLexicalUnit();
            if (nextParam == null) {
                return AttrUtil.attrTypeToCSSOMType(unit, attrSyntax);
            }
            if (nextParam.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                return CSSValue.Type.UNKNOWN;
            }
        } else {
            attrSyntax = SyntaxParser.createSimpleSyntax("string");
        }
        if ((fallback = nextParam.getNextLexicalUnit()) == null) {
            return AttrUtil.attrTypeToCSSOMType(unit, attrSyntax);
        }
        if (!AttrUtil.valueFitsAttrType(fallback, unit, attrSyntax)) {
            return CSSValue.Type.UNKNOWN;
        }
        return AttrUtil.attrTypeToCSSOMType(unit, attrSyntax);
    }

    private static CSSValue.Type attrTypeToCSSOMType(short unit, CSSValueSyntax attrSyntax) {
        CSSValue.Type finalType;
        if (attrSyntax == null) {
            return unit == 1 ? CSSValue.Type.UNKNOWN : CSSValue.Type.NUMERIC;
        }
        switch (attrSyntax.getCategory()) {
            case string: {
                finalType = CSSValue.Type.STRING;
                break;
            }
            case url: {
                finalType = CSSValue.Type.URI;
                break;
            }
            case customIdent: {
                finalType = CSSValue.Type.IDENT;
                break;
            }
            case color: {
                finalType = CSSValue.Type.COLOR;
                break;
            }
            case number: 
            case percentage: 
            case length: 
            case angle: 
            case time: 
            case frequency: 
            case flex: {
                finalType = CSSValue.Type.NUMERIC;
                break;
            }
            default: {
                finalType = CSSValue.Type.UNKNOWN;
            }
        }
        return finalType;
    }

    private static boolean valueFitsAttrType(LexicalUnit value, short unit, CSSValueSyntax attrSyntax) {
        LexicalUnit.LexicalType luType = value.getLexicalUnitType();
        if (attrSyntax == null) {
            return luType == LexicalUnit.LexicalType.DIMENSION || luType == LexicalUnit.LexicalType.REAL || luType == LexicalUnit.LexicalType.PERCENTAGE || luType == LexicalUnit.LexicalType.INTEGER;
        }
        return value.matches(attrSyntax) == CSSValueSyntax.Match.TRUE;
    }
}

