/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.jar.ResourceFile;
import generic.theme.ApplicationThemeDefaults;
import generic.theme.GThemeValueMap;
import generic.theme.LafType;
import generic.theme.ThemePropertyFileReader;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyFileThemeDefaults
implements ApplicationThemeDefaults {
    private GThemeValueMap defaults = new GThemeValueMap();
    private GThemeValueMap darkDefaults = new GThemeValueMap();
    private Map<LafType, GThemeValueMap> lafDefaultsMap = new HashMap<LafType, GThemeValueMap>();

    PropertyFileThemeDefaults() {
        this.loadThemeDefaultFiles();
    }

    private void loadThemeDefaultFiles() {
        this.defaults.clear();
        this.darkDefaults.clear();
        List themeDefaultFiles = Application.findFilesByExtensionInApplication((String)".theme.properties");
        for (ResourceFile resourceFile : themeDefaultFiles) {
            try {
                ThemePropertyFileReader reader = new ThemePropertyFileReader(resourceFile);
                this.defaults.load(reader.getDefaultValues());
                this.darkDefaults.load(reader.getDarkDefaultValues());
                this.processLookAndFeelSpecificValues(reader.getLookAndFeelSections());
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Error reading theme properties file: " + resourceFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void processLookAndFeelSpecificValues(Map<LafType, GThemeValueMap> customSections) {
        for (LafType lafType : customSections.keySet()) {
            GThemeValueMap map = this.lafDefaultsMap.computeIfAbsent(lafType, t -> new GThemeValueMap());
            map.load(customSections.get((Object)lafType));
        }
    }

    @Override
    public GThemeValueMap getLightValues() {
        return this.defaults;
    }

    @Override
    public GThemeValueMap getDarkValues() {
        return this.darkDefaults;
    }

    @Override
    public GThemeValueMap getLookAndFeelValues(LafType lafType) {
        return this.lafDefaultsMap.get((Object)lafType);
    }
}

