/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.sys.EmuIOException;
import ghidra.pcode.emu.unix.EmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public interface EmuUnixFileSystem<T> {
    public EmuUnixFile<T> newFile(String var1, int var2) throws EmuIOException;

    public EmuUnixFile<T> createOrGetFile(String var1, int var2) throws EmuIOException;

    public EmuUnixFile<T> getFile(String var1) throws EmuIOException;

    public void putFile(String var1, EmuUnixFile<T> var2) throws EmuIOException;

    public void unlink(String var1, EmuUnixUser var2) throws EmuIOException;

    public EmuUnixFile<T> open(String var1, Set<OpenFlag> var2, EmuUnixUser var3, int var4) throws EmuIOException;

    public static enum OpenFlag {
        O_RDONLY,
        O_WRONLY,
        O_RDWR,
        O_CREAT,
        O_TRUNC,
        O_APPEND;


        public static Set<OpenFlag> set(OpenFlag ... flags) {
            return OpenFlag.set(Arrays.asList(flags));
        }

        public static Set<OpenFlag> set(Collection<OpenFlag> flags) {
            if (flags.contains((Object)O_RDONLY) && flags.contains((Object)O_WRONLY)) {
                throw new IllegalArgumentException("Cannot be read only and write only");
            }
            if (flags instanceof EnumSet) {
                return Collections.unmodifiableSet((EnumSet)flags);
            }
            return Collections.unmodifiableSet(EnumSet.copyOf(flags));
        }

        public static boolean isRead(Collection<OpenFlag> flags) {
            return flags.contains((Object)O_RDONLY) || flags.contains((Object)O_RDWR);
        }

        public static boolean isWrite(Collection<OpenFlag> flags) {
            return flags.contains((Object)O_WRONLY) || flags.contains((Object)O_RDWR);
        }
    }
}

