/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.theme.GIcon;
import ghidra.feature.vt.api.db.DeletedMatch;
import ghidra.feature.vt.api.impl.VTEvent;
import ghidra.feature.vt.api.impl.VersionTrackingChangeRecord;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.CreateImpliedMatchAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.impliedmatches.ImpliedMatchWrapperRowObject;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchesTableModel;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.MatchStatusRenderer;
import ghidra.feature.vt.gui.util.VTSymbolRenderer;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.EventType;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import resources.Icons;

public class VTImpliedMatchesTableProvider
extends ComponentProviderAdapter
implements VTControllerListener {
    private static final Icon REFERNCE_FROM_ICON = Icons.NAVIGATE_ON_OUTGOING_EVENT_ICON;
    private static final Icon REFERNCE_TO_ICON = Icons.NAVIGATE_ON_INCOMING_EVENT_ICON;
    private VTController controller;
    private JComponent component;
    private VTImpliedMatchesTableModel impliedMatchTableModel;
    private ListSelectionListener impliedSelectionListener;
    private GTable impliedMatchesTable;
    private GhidraTableFilterPanel<ImpliedMatchWrapperRowObject> filterPanel;
    private ToggleDockingAction showReferenceLocationAction;
    protected boolean showReferenceLocation = true;
    private ToggleDockingAction showReferenceToLocationAction;

    public VTImpliedMatchesTableProvider(VTController controller) {
        super(controller.getTool(), "Version Tracking Implied Matches", VTPlugin.OWNER);
        this.controller = controller;
        controller.addListener(this);
        this.setWindowGroup("VTResults");
        this.setIcon((Icon)new GIcon("icon.version.tracking.provider.implied.match"));
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.component = this.createComponent();
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Implied_Matches_Table"));
        this.createActions();
        this.addToTool();
        this.setVisible(true);
    }

    private JComponent createComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        GThreadedTablePanel<ImpliedMatchWrapperRowObject> tablePanel = this.createImpliedMatchTablePanel();
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.impliedMatchesTable, (RowObjectTableModel)this.impliedMatchTableModel);
        panel.add((Component)tablePanel, "Center");
        panel.add((Component)this.filterPanel, "South");
        String namePrefix = "Implied Matches";
        this.impliedMatchesTable.setAccessibleNamePrefix(namePrefix);
        this.filterPanel.setAccessibleNamePrefix(namePrefix);
        return panel;
    }

    private void createActions() {
        this.showReferenceLocationAction = new ToggleDockingAction("Show Reference Locations", VTPlugin.OWNER){

            public void actionPerformed(ActionContext context) {
                VTImpliedMatchesTableProvider.this.showReferenceLocation = true;
                VTImpliedMatchesTableProvider.this.showReferenceToLocationAction.setSelected(false);
                VTImpliedMatchesTableProvider.this.navigateSelectedItem();
            }
        };
        this.showReferenceLocationAction.setSelected(true);
        this.showReferenceLocationAction.setToolBarData(new ToolBarData(REFERNCE_FROM_ICON, "2"));
        this.showReferenceLocationAction.setDescription("<html>Sets table selection navigation mode to navigate <br> to <b>Source</b> and <b>Dest Reference Address</b> columns");
        this.showReferenceLocationAction.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Navigate_References"));
        this.addLocalAction((DockingActionIf)this.showReferenceLocationAction);
        this.showReferenceToLocationAction = new ToggleDockingAction("Show Locations Reference", VTPlugin.OWNER){

            public void actionPerformed(ActionContext context) {
                VTImpliedMatchesTableProvider.this.showReferenceLocation = false;
                VTImpliedMatchesTableProvider.this.showReferenceLocationAction.setSelected(false);
                VTImpliedMatchesTableProvider.this.navigateSelectedItem();
            }
        };
        this.showReferenceToLocationAction.setToolBarData(new ToolBarData(REFERNCE_TO_ICON, "2"));
        this.showReferenceToLocationAction.setDescription("<html>Sets table selection navigation mode to navigate <br> to <b>Source</b> and <b>Dest Address</b> columns");
        this.showReferenceToLocationAction.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Navigate_Match"));
        this.addLocalAction((DockingActionIf)this.showReferenceToLocationAction);
        CreateImpliedMatchAction action = new CreateImpliedMatchAction(this.controller, this);
        this.addLocalAction((DockingActionIf)action);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void componentHidden() {
    }

    public void componentShown() {
        this.impliedMatchTableModel.sessionChanged();
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
        if (!this.isVisible()) {
            return;
        }
        this.impliedMatchTableModel.reload();
    }

    @Override
    public void optionsChanged(Options options) {
    }

    public void readConfigState(SaveState saveState) {
    }

    public void writeConfigState(SaveState saveState) {
    }

    @Override
    public void sessionChanged(VTSession session) {
        if (!this.isVisible()) {
            return;
        }
        this.impliedMatchTableModel.sessionChanged();
    }

    @Override
    public void disposed() {
        if (this.impliedMatchesTable == null) {
            return;
        }
        ListSelectionModel selectionModel = this.impliedMatchesTable.getSelectionModel();
        selectionModel.removeListSelectionListener(this.impliedSelectionListener);
        this.impliedMatchesTable.dispose();
        this.impliedMatchTableModel.dispose();
        this.filterPanel.dispose();
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        boolean matchesContextChanged = false;
        for (int i = 0; i < ev.numRecords(); ++i) {
            VersionTrackingChangeRecord vtRecord;
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            EventType eventType = doRecord.getEventType();
            if (eventType == VTEvent.ASSOCIATION_STATUS_CHANGED || eventType == VTEvent.ASSOCIATION_MARKUP_STATUS_CHANGED) {
                matchesContextChanged = true;
                continue;
            }
            if (eventType == DomainObjectEvent.RESTORED || eventType == VTEvent.MATCH_SET_ADDED) {
                this.reload();
                matchesContextChanged = true;
                continue;
            }
            if (eventType == VTEvent.MATCH_ADDED) {
                vtRecord = (VersionTrackingChangeRecord)doRecord;
                this.impliedMatchTableModel.matchAdded((VTMatch)vtRecord.getNewValue());
                matchesContextChanged = true;
                continue;
            }
            if (eventType != VTEvent.MATCH_DELETED) continue;
            vtRecord = (VersionTrackingChangeRecord)doRecord;
            this.impliedMatchTableModel.matchDeleted((DeletedMatch)vtRecord.getOldValue());
            matchesContextChanged = true;
        }
        if (matchesContextChanged) {
            this.impliedMatchesTable.repaint();
            this.tool.contextChanged((ComponentProvider)this);
        }
    }

    private void reload() {
        this.impliedMatchTableModel.clear();
        this.impliedMatchTableModel.reload();
    }

    private GThreadedTablePanel<ImpliedMatchWrapperRowObject> createImpliedMatchTablePanel() {
        this.impliedMatchTableModel = new VTImpliedMatchesTableModel(this.controller);
        GhidraThreadedTablePanel impliedMatchTablePanel = new GhidraThreadedTablePanel((ThreadedTableModel)this.impliedMatchTableModel);
        this.impliedMatchesTable = impliedMatchTablePanel.getTable();
        this.impliedSelectionListener = e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.navigateSelectedItem();
            this.tool.contextChanged((ComponentProvider)this);
        };
        ListSelectionModel selectionModel = this.impliedMatchesTable.getSelectionModel();
        selectionModel.addListSelectionListener(this.impliedSelectionListener);
        this.impliedMatchTableModel.addTableModelListener(e -> {
            int filteredCount = this.impliedMatchTableModel.getRowCount();
            int unfilteredCount = this.impliedMatchTableModel.getUnfilteredRowCount();
            String sessionName = this.controller.getVersionTrackingSessionName();
            StringBuffer buffy = new StringBuffer();
            buffy.append("[Session: ").append(sessionName).append("] ");
            buffy.append('-').append(filteredCount).append(" matches");
            if (filteredCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(')');
            }
            this.setSubTitle(buffy.toString());
        });
        TableColumnModel columnModel = this.impliedMatchesTable.getColumnModel();
        int sourceLabelColumnIndex = this.impliedMatchTableModel.getColumnIndex(AbstractVTMatchTableModel.SourceLabelTableColumn.class);
        TableColumn sourceLabelColumn = columnModel.getColumn(sourceLabelColumnIndex);
        sourceLabelColumn.setCellRenderer((TableCellRenderer)((Object)new VTSymbolRenderer(this.controller.getServiceProvider(), (JComponent)this.impliedMatchesTable)));
        int destinationLabelColumnIndex = this.impliedMatchTableModel.getColumnIndex(AbstractVTMatchTableModel.DestinationLabelTableColumn.class);
        TableColumn destinationLabelColumn = columnModel.getColumn(destinationLabelColumnIndex);
        destinationLabelColumn.setCellRenderer((TableCellRenderer)((Object)new VTSymbolRenderer(this.controller.getServiceProvider(), (JComponent)this.impliedMatchesTable)));
        int statusColumnIndex = this.impliedMatchTableModel.getColumnIndex(AbstractVTMatchTableModel.StatusTableColumn.class);
        TableColumn statusColumn = columnModel.getColumn(statusColumnIndex);
        statusColumn.setCellRenderer((TableCellRenderer)((Object)new MatchStatusRenderer()));
        this.impliedMatchesTable.setPreferredScrollableViewportSize(new Dimension(1100, 600));
        return impliedMatchTablePanel;
    }

    protected void navigateSelectedItem() {
        if (this.impliedMatchesTable.getSelectedRowCount() != 1) {
            return;
        }
        RowObjectTableModel model = (RowObjectTableModel)this.impliedMatchesTable.getModel();
        int selectedRow = this.impliedMatchesTable.getSelectedRow();
        VTImpliedMatchInfo impliedMatch = (VTImpliedMatchInfo)model.getRowObject(selectedRow);
        if (this.showReferenceLocation) {
            this.controller.gotoSourceLocation(impliedMatch.getSourceReferenceLocation());
            this.controller.gotoDestinationLocation(impliedMatch.getDestinationReferenceLocation());
        } else {
            ProgramLocation sourceLoc = new ProgramLocation(this.controller.getSourceProgram(), impliedMatch.getSourceAddress());
            ProgramLocation destinationLoc = new ProgramLocation(this.controller.getDestinationProgram(), impliedMatch.getDestinationAddress());
            this.controller.gotoSourceLocation(sourceLoc);
            this.controller.gotoDestinationLocation(destinationLoc);
        }
    }

    public List<VTMatch> getSelectedMatches() {
        int[] selectedRows;
        RowObjectTableModel model = (RowObjectTableModel)this.impliedMatchesTable.getModel();
        ArrayList<VTMatch> list = new ArrayList<VTMatch>();
        for (int row : selectedRows = this.impliedMatchesTable.getSelectedRows()) {
            ImpliedMatchWrapperRowObject rowObject = (ImpliedMatchWrapperRowObject)model.getRowObject(row);
            VTMatch match = rowObject.getMatch();
            if (match == null) continue;
            list.add(match);
        }
        return list;
    }

    public List<VTImpliedMatchInfo> getSelectedImpliedMatches() {
        int[] selectedRows;
        RowObjectTableModel model = (RowObjectTableModel)this.impliedMatchesTable.getModel();
        ArrayList<VTImpliedMatchInfo> list = new ArrayList<VTImpliedMatchInfo>();
        for (int row : selectedRows = this.impliedMatchesTable.getSelectedRows()) {
            ImpliedMatchWrapperRowObject rowObject = (ImpliedMatchWrapperRowObject)model.getRowObject(row);
            VTMatch match = rowObject.getMatch();
            if (match != null) continue;
            list.add(rowObject);
        }
        return list;
    }
}

