/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.datawindow.DataWindowProvider;
import ghidra.app.plugin.core.datawindow.FilterAction;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramTreeService;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays defined data", description="This plugin provides a component for showing all the defined data in the current program.  The data display can be filtered and used for navigation.", servicesRequired={GoToService.class}, eventsConsumed={ViewChangedPluginEvent.class})
public class DataWindowPlugin
extends ProgramPlugin {
    private DockingAction selectAction;
    private FilterAction filterAction;
    private DataWindowProvider provider;
    private SwingUpdateManager resetUpdateMgr;
    private SwingUpdateManager reloadUpdateMgr;
    private boolean resetTypesNeeded;
    private DomainObjectListener domainObjectListener = this.createDomainObjectListener();
    private SortedMap<String, Boolean> typeEnablementByDisplayName = new TreeMap<String, Boolean>(new DataTypeNameComparator());
    private boolean isFilterEnabled = false;
    private Coverage coverage = Coverage.PROGRAM;

    public DataWindowPlugin(PluginTool tool) {
        super(tool);
        this.resetUpdateMgr = new SwingUpdateManager(100, 60000, () -> this.doReset());
        this.reloadUpdateMgr = new SwingUpdateManager(100, 60000, () -> this.doReload());
    }

    public void init() {
        super.init();
        this.provider = new DataWindowProvider(this);
        this.createActions();
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        this.resetUpdateMgr.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener(this.domainObjectListener);
        }
        this.provider.dispose();
        super.dispose();
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).any(new EventType[]{DomainObjectEvent.RESTORED}).terminate(() -> this.resetTypes())).any(new EventType[]{ProgramEvent.MEMORY_BLOCK_ADDED, ProgramEvent.MEMORY_BLOCK_REMOVED, ProgramEvent.CODE_REMOVED}).terminate(e -> this.reload())).any(new EventType[]{ProgramEvent.DATA_TYPE_ADDED, ProgramEvent.DATA_TYPE_CHANGED, ProgramEvent.DATA_TYPE_MOVED, ProgramEvent.DATA_TYPE_RENAMED, ProgramEvent.DATA_TYPE_REPLACED, ProgramEvent.DATA_TYPE_SETTING_CHANGED}).terminate(() -> this.resetTypes())).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.CODE_ADDED}).call(r -> this.codeAdded((ProgramChangeRecord)r)).build();
    }

    private void codeAdded(ProgramChangeRecord rec) {
        if (rec.getNewValue() instanceof Data) {
            this.provider.dataAdded(rec.getStart());
        }
    }

    void dataWindowShown() {
        if (this.resetTypesNeeded) {
            this.resetTypes();
        }
    }

    void setFilterEnabled(boolean enabled) {
        this.isFilterEnabled = enabled;
        this.reload();
    }

    void setFilter(SortedMap<String, Boolean> typeEnabledMap, Coverage coverage) {
        this.isFilterEnabled = true;
        this.typeEnablementByDisplayName = new TreeMap<String, Boolean>(typeEnabledMap);
        this.coverage = coverage;
        this.reload();
    }

    private void reload() {
        this.reloadUpdateMgr.update();
    }

    private void doReload() {
        this.provider.reload();
    }

    @Override
    public void processEvent(PluginEvent event) {
        if (event instanceof ViewChangedPluginEvent) {
            if (this.isFilterEnabled && this.provider.isVisible()) {
                this.reload();
            }
        } else {
            super.processEvent(event);
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener(this.domainObjectListener);
        this.provider.programOpened(program);
        this.filterAction.setEnabled(true);
        this.resetTypes();
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener(this.domainObjectListener);
        this.provider.programClosed();
        this.filterAction.setEnabled(false);
    }

    Program getProgram() {
        return this.currentProgram;
    }

    ProgramSelection getSelection() {
        return this.currentSelection;
    }

    DataWindowProvider getProvider() {
        return this.provider;
    }

    private void createActions() {
        this.selectAction = new MakeProgramSelectionAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.selectAction);
        this.filterAction = new FilterAction(this);
        this.filterAction.setEnabled(this.currentProgram != null);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.filterAction);
        SelectionNavigationAction selectionAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectionAction);
    }

    void selectData(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.currentProgram);
        this.firePluginEvent(pspe);
        this.processEvent(pspe);
    }

    private void resetTypes() {
        if (this.provider.isVisible()) {
            this.resetUpdateMgr.update();
        } else {
            this.resetTypesNeeded = true;
        }
    }

    private void doReset() {
        this.resetTypesNeeded = false;
        this.typeEnablementByDisplayName.clear();
        if (this.currentProgram == null) {
            return;
        }
        ProgramBasedDataTypeManager dtm = this.currentProgram.getDataTypeManager();
        Iterator it = dtm.getAllDataTypes();
        while (it.hasNext()) {
            DataType type = (DataType)it.next();
            this.typeEnablementByDisplayName.put(type.getDisplayName(), true);
        }
        this.provider.reload();
    }

    boolean isTypeEnabled(String type) {
        if (!this.isFilterEnabled) {
            return true;
        }
        Boolean enabled = (Boolean)this.typeEnablementByDisplayName.get(type);
        return enabled != null && enabled != false;
    }

    SortedMap<String, Boolean> getTypeMap() {
        return this.typeEnablementByDisplayName;
    }

    AddressSet getLimitedAddresses() {
        ProgramTreeService service;
        if (this.coverage == Coverage.SELECTION) {
            AddressSet addrs = new AddressSet();
            AddressRangeIterator it = this.currentSelection.getAddressRanges();
            while (it.hasNext()) {
                addrs.add((AddressRange)it.next());
            }
            return addrs;
        }
        if (this.coverage == Coverage.VIEW && (service = (ProgramTreeService)this.tool.getService(ProgramTreeService.class)) != null) {
            return service.getView();
        }
        return null;
    }

    private static class DataTypeNameComparator
    implements Comparator<String> {
        private DataTypeNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 != null) {
                if (!o1.equalsIgnoreCase(o2)) {
                    return o1.compareToIgnoreCase(o2);
                }
                return o1.compareTo(o2);
            }
            return -1;
        }
    }

    public static enum Coverage {
        PROGRAM("Entire Program"),
        SELECTION("Current Selection"),
        VIEW("Current View");

        private String displayName;

        private Coverage(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

