/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionTable;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InstructionTablePanel
extends JPanel {
    private JScrollPane scrollPane;
    private InstructionTable instructionTable;
    private InstructionSearchPlugin plugin;
    private InstructionSearchDialog dialog;
    private int numColumns;
    private JPanel workPanel;

    public InstructionTablePanel(int numColumns, InstructionSearchPlugin plugin, InstructionSearchDialog dialog) {
        this.plugin = plugin;
        this.dialog = dialog;
        this.numColumns = numColumns;
        try {
            this.setup();
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("error creating instruction table: " + String.valueOf((Object)e)));
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public InstructionTable getTable() {
        return this.instructionTable;
    }

    public JPanel getWorkPanel() {
        return this.workPanel;
    }

    private void setup() throws InvalidInputException {
        this.workPanel = new JPanel();
        this.workPanel.setLayout(new BorderLayout());
        this.workPanel.setName("InstructionTablePanel");
        this.instructionTable = new InstructionTable(this.numColumns + 1, this.plugin, this.dialog);
        this.scrollPane = new JScrollPane((Component)((Object)this.instructionTable));
        this.workPanel.add((Component)this.instructionTable.getToolbar(), "North");
        this.workPanel.add((Component)this.scrollPane, "Center");
    }
}

