/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.app.plugin.core.analysis.ReferenceAddressPair;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.PreviewTableCellData;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.PreviewTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public abstract class AbstractReferencePreviewTableColumn
extends ProgramLocationTableColumnExtensionPoint<ReferenceAddressPair, PreviewTableCellData> {
    private PreviewTableColumn previewTableColumn = new PreviewTableColumn();

    abstract Address getAddress(ReferenceAddressPair var1);

    abstract String getColumnNamePrefix();

    public PreviewTableCellData getValue(ReferenceAddressPair rowObject, Settings settings, Program pgm, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Address address = this.getAddress(rowObject);
        ProgramLocation programLocation = new ProgramLocation(pgm, address);
        return this.previewTableColumn.getValue(programLocation, settings, pgm, serviceProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(ReferenceAddressPair rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        Address address = this.getAddress(rowObject);
        ProgramLocation programLocation = new ProgramLocation(program, address);
        return this.previewTableColumn.getProgramLocation(programLocation, settings, program, serviceProvider);
    }

    public String getColumnDisplayName(Settings settings) {
        return this.getColumnNamePrefix() + this.previewTableColumn.getColumnDisplayName(settings);
    }

    public int getMaxLines(Settings settings) {
        return this.previewTableColumn.getMaxLines(settings);
    }

    public GColumnRenderer<PreviewTableCellData> getColumnRenderer() {
        return this.previewTableColumn.getColumnRenderer();
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return this.previewTableColumn.getSettingsDefinitions();
    }
}

