# frozen_string_literal: true

class AddNotEmptyConstraintToVulnerabilityStatisticsTraversalIds < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.6'

  def up
    add_check_constraint(
      :vulnerability_statistics,
      'cardinality(traversal_ids) > 0',
      'check_vulnerability_statistics_traversal_ids_not_empty',
      validate: false
    )
  end

  def down
    remove_check_constraint(
      :vulnerability_statistics,
      'check_vulnerability_statistics_traversal_ids_not_empty'
    )
  end
end
