---
stage: Plan
group: Optimize
info: For assistance with this tutorial, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: 'チュートリアル: アナリティクスを利用したウェブサイトプロジェクトをセットアップする'
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

複雑なプロジェクト（ウェブサイトなど）に取り組む場合、他の人と協力してビルドおよびメンテナンスを行うことが多いでしょう。チームでのコントリビュートやコミュニケーションの方法は、プロジェクトを成功させることも失敗させることもあります。そのため、チームメンバーが共通の目標を共有し、達成できるようにするプロセスが必要です。アナリティクスのメトリクスは、チームの状況を理解し、より良く協力できるようにプロセスを調整する必要があるかどうかを判断するのに役立ちます。GitLabは、インスタンス、グループ、およびプロジェクトレベルでさまざまな種類の[analytics](../../user/analytics/_index.md)インサイトを提供します。このリストが長く、どこから始めればよいかわからない場合は、このチュートリアルが最適です。

このチュートリアルでは、ウェブサイトプロジェクトの例をセットアップし、他のGitLabユーザーとコントリビュートし、プロジェクトレベルのアナリティクスレポートを使用してプロジェクトのビルドを評価する方法を学びます。

これから次の手順を実行します:

1. テンプレートからプロジェクトを作成します。
1. プロジェクトにユーザーを招待します。
1. プロジェクトラベルを作成します。
1. カスタムステージでバリューストリームを作成します。
1. インサイトレポートを作成します。
1. マージリクエストとイシュー分析を表示します。

## はじめる前 {#before-you-begin}

- プロジェクトを作成するグループのオーナーロールが必要です。

## テンプレートからプロジェクトを作成 {#create-a-project-from-a-template}

まず、グループにプロジェクトを作成する必要があります。

GitLabにはプロジェクトテンプレートが用意されており、さまざまなユースケースに必要なすべてのファイルを使用してプロジェクトを簡単にセットアップできます。ここでは、Hugoウェブサイトのプロジェクトを作成します。

プロジェクトを作成するには、プロジェクトを作成する:

1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。
1. **テンプレートから作成**を選択します。
1. **Pages/Hugo**テンプレートを選択します。
1. **プロジェクト名**テキストボックスに、名前（たとえば、`My website`）を入力します。
1. **プロジェクトのURL**ドロップダウンリストから、プロジェクトを作成するグループを選択します。
1. **プロジェクトslug**テキストボックスに、プロジェクトのslugを入力します（たとえば、`my-website`）。
1. オプション。**プロジェクトの説明**テキストボックスに、プロジェクトのプロジェクトの説明を入力します。たとえば、「Hugoでビルドされたウェブサイトのアナリティクスを利用したプロジェクト」などです。この説明はいつでも追加または編集できます。
1. **表示レベル**で、プロジェクトに必要なレベルを選択します。グループにプロジェクトを作成する場合、プロジェクトの表示レベル設定は、親グループの表示レベルと同じか、それよりも制限的である必要があります。
1. **プロジェクトを作成**を選択します。

これで、Hugoウェブサイトに必要なすべてのファイルを含むプロジェクトが作成されました。

## プロジェクトにユーザーを招待 {#invite-users-to-the-project}

ウェブサイトのような大規模なプロジェクトに取り組む場合、デベロッパーやデザイナーなど、他の人とコントリビュートする必要があるでしょう。すべてのファイル、イシュー、レポートにアクセスできるように、プロジェクトに招待する必要があります。

`My website`プロジェクトにユーザーを招待するには:

1. プロジェクトで、**管理** > **メンバー**を選択します。
1. **メンバーを招待**を選択します。
1. ユーザーの**ユーザー名**を入力します。
1. **ロール**ドロップダウンリストから、少なくとも**デベロッパー**ロールを選択します。ユーザーがアナリティクスを表示し、イシューとマージリクエストにコントリビュートするには、少なくともデベロッパーロールが必要です。
1. オプション。**アクセス有効期限**ピッカーで、日付を選択します。招待されたメンバーが限られた時間のみプロジェクトにコントリビュートすることが予想される場合は、この手順をお勧めします。
1. **招待**を選択します。

招待されたユーザーは、プロジェクトのメンバーになっているはずです。プロジェクトの[メンバーの表示、フィルター、および検索](../../user/project/members/_index.md#filter-and-sort-project-members)ができます。

## プロジェクトラベルを作成 {#create-project-labels}

[ラベル](../../user/project/labels.md)は、イシュー、マージリクエスト、およびエピックを整理および追跡するのに役立ちます。プロジェクトとグループに必要な数のラベルを作成できます。たとえば、このようなウェブサイトプロジェクトでは、`feature request`と`bug`ラベルが役立つ場合があります。

`My website`プロジェクトでプロジェクトラベルを作成するには:

1. **管理**>**ラベル**を選択します。
1. **新しいラベル**を選択します。
1. **タイトル**フィールドに`feature request`と入力します。
1. オプション。**説明**フィールドに、このラベルの使用方法と時期に関する追加情報を入力します。
1. オプション。使用可能な色から選択するか、**背景色**フィールドに特定の色を表す16進数のカラー値を入力して、色を選択します。
1. **ラベルを作成**を作成を選択します。

これでラベルが[ラベルリスト](../../user/project/labels.md#view-project-labels)に表示され、それを使用してカスタムステージでバリューストリームを作成できます。

## カスタムステージでバリューストリームを作成 {#create-a-value-stream-with-a-custom-stage}

共同作業者がいるプロジェクトができたので、アクティビティーの追跡と視覚化を開始できます。[バリューストリーム分析](../../user/group/value_stream_analytics/_index.md)は、アイデアから本番環境までの時間を測定し、開発プロセスの非効率性を特定するのに役立ちます。アナリティクス機能のクリックスルーデモについては、[バリューストリーム管理製品ツアー](https://gitlab.navattic.com/vsm)をご覧ください。

開始するには、`My website`プロジェクトでバリューストリームを作成します:

1. **分析** > **バリューストリーム分析**を選択します。
1. **New Value Stream**（新しいバリューストリーム）を選択します。
1. バリューストリームの名前を入力します（たとえば、`My website value stream`）。
1. **デフォルトテンプレートから作成**を選択します。
1. カスタムステージを追加するには、**ステージを追加する**を選択します。
   - ステージの名前を入力します（たとえば、`Labeled MRs merged`）。
   - **開始イベント**ドロップダウンリストから、**マージリクエストのラベルが追加された**を選択し、`feature request`ラベルを選択します。
   - **Stop event**（停止イベント）ドロップダウンリストから、**マージリクエストがマージされた**を選択します。
1. **Create value stream**（バリューストリームを作成）を選択します。

バリューストリームを作成すると、データの収集とロードが開始されます。この処理にはしばらく時間がかかる場合があります。準備ができると、ダッシュボードが**分析** > **バリューストリーム分析**に表示されます。

それまでの間、プロジェクトのインサイトレポートの作成を開始できます。

## インサイトレポートを作成 {#create-an-insights-report}

バリューストリーム分析は開発プロセス全体の概要を示しますが、[インサイト](../../user/project/insights/_index.md)はプロジェクトのイシューの作成とクローズ、およびマージリクエストの平均マージ時間のより詳細なビューを提供します。このデータの視覚化は、イシューのトリアージをひとめで判断するのに役立ちます。

必要に応じて、さまざまなチャートを含むインサイトレポートを多数作成できます。たとえば、重大度別のバグの積み上げ棒チャートや、1か月間にオープンされたイシューの折れ線チャートなどです。

`My website`プロジェクトでインサイトレポートを作成するには:

1. ファイルリストの上にあるプラスアイコンを選択し、**新しいファイル**を選択します。
1. **ファイル名**テキストボックスに、`.gitlab/insights.yml`と入力します。
1. 大きなテキストボックスに、次のコードを入力します:

   ```yaml
   bugsCharts:
      title: "Charts for bugs"
      charts:
         - title: "Monthly bugs created"
            description: "Open bugs created per month"
            type: bar
            query:
            data_source: issuables
            params:
               issuable_type: issue
               issuable_state: opened
               filter_labels:
                  - bug
               group_by: month
               period_limit: 12
   ```

1. **変更をコミットする**を選択します。

これで、過去12か月間に毎月作成された`~bug`ラベルの付いたイシューの数を表示するインサイトの棒チャートが作成されました。あなたと、少なくともデベロッパーロールを持つプロジェクトメンバーは、**分析** > **インサイト**でレポートを表示できます。

## マージリクエストとイシュー分析を表示 {#view-merge-request-and-issue-analytics}

インサイトレポートに加えて、プロジェクトのマージリクエストとイシューの詳細なアナリティクスを取得できます。[マージリクエスト分析](../../user/analytics/merge_request_analytics.md)と[イシュー分析](../../user/group/issues_analytics/_index.md)には、割り当て先、マージリクエストスループット、イシューステータスなどのメトリクスを含むチャートと表が表示されます。

マージリクエストとイシュー分析を表示するには、`My website`プロジェクトで、**分析** > **マージリクエスト分析**または**分析** > **イシュー分析**を選択します。

以上です。これで、チームと効率的にコントリビュートできる、アナリティクスを利用したウェブサイトプロジェクトができました。
