---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Fastly API user or automation token'
---

## Description

The response body contains content that matches the pattern of a Fastly API user or automation token was identified. Fastly API tokens can grant read write or read only access depending on how they are configured.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke an API token:

- Sign in to the Fastly web interface at <https://manage.fastly.com/account>
- Go to "Account" and then "API Tokens" in the left hand menu
- Find the token you want to delete and note any details about its scope.
- When ready, select the trash icon
- When prompted select "Delete"

For more information, please see [Fastly's documentation on Using API Tokens](https://docs.fastly.com/en/guides/using-api-tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.40 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
