---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 検出
description: 脆弱性の検出と結果の評価。
---

プロジェクトのリポジトリと、ソフトウェア開発ライフサイクル全体におけるアプリケーションの挙動における脆弱性を検出します。

開発中の脆弱性のリスク管理を支援するため:

- ブランチにプッシュすると、セキュリティスキャナーが実行されます。
- ブランチで検出された脆弱性の詳細を表示できます。デベロッパーは、この時点で脆弱性を修正し、本番環境に到達する前に修正できます。
- オプションで、脆弱性を含むマージリクエストに対する追加の承認を強制できます。詳細については、[マージリクエスト承認ポリシー](../policies/merge_request_approval_policies.md)を参照してください。

開発環境外の脆弱性を管理するには:

- セキュリティスキャンは、スケジュールするか、手動で実行できます。
- デフォルトブランチで検出された脆弱性は、脆弱性レポートに表示されます。このレポートを使用して、脆弱性のトリアージ、分析、修正を行います。

## セキュリティスキャン {#security-scanning}

セキュリティスキャンを最大限に活用するには、以下を理解することが重要です:

- セキュリティスキャンをトリガーする方法。
- アプリケーションまたはリポジトリのどの側面がスキャンされるか。
- どのスキャナーを実行するかを決定するもの。
- セキュリティスキャンがどのように行われるか。

### トリガー {#triggers}

CI/CDパイプラインのセキュリティスキャンは、変更がプロジェクトのリポジトリにプッシュされると、デフォルトでトリガーされます。

次の方法でセキュリティスキャンを実行することもできます:

- CI/CDパイプラインを手動で実行する。
- スキャン実行ポリシーを使用して、セキュリティスキャンをスケジュールする。
- DASTのみの場合は、オンデマンドDASTスキャンを手動で、またはスケジュールに従って実行します。
- SASTのみの場合は、VS Code用GitLab Workflow拡張機能を使用してスキャンを実行します。

### 検出カバレッジ {#detection-coverage}

プロジェクトのリポジトリとアプリケーションの動作をスキャンして、脆弱性がないか調べます:

- リポジトリスキャンは、プロジェクトのリポジトリ内の脆弱性を検出できます。カバレッジには、アプリケーションのソースコード、およびそれが依存するライブラリとコンテナイメージが含まれます。
- アプリケーションとそのAPIの挙動テストでは、ランタイムにのみ発生する脆弱性を検出できます。

#### リポジトリスキャン {#repository-scanning}

プロジェクトのリポジトリには、ソースコード、依存関係の宣言、およびインフラストラクチャの定義が含まれている場合があります。リポジトリスキャンは、これらのそれぞれで脆弱性を検出できます。

リポジトリスキャンツールには、次のようなものがあります:

- 静的アプリケーションセキュリティテスト（SAST）: ソースコードを分析して脆弱性を検出します。
- Infrastructure as Code（IaC）スキャン: アプリケーションのインフラストラクチャ定義の脆弱性を検出します。
- シークレット検出: シークレットがリポジトリにコミットされるのを検出してブロックします。
- 依存関係スキャン: アプリケーションの依存関係とコンテナイメージの脆弱性を検出します。

#### 挙動テスト {#behavioral-testing}

挙動テストでは、既知の脆弱性と予期しない挙動をテストするために、デプロイ可能なアプリケーションが必要です。

挙動テストツールには、次のようなものがあります:

- 動的アプリケーションセキュリティテスト（DAST）: 既知の攻撃ベクターについてアプリケーションをテストします。
- APIセキュリティテスト: 既知の攻撃と入力に対する脆弱性についてアプリケーションのAPIをテストします。
- カバレッジガイドファズテスト: 予期しない挙動についてアプリケーションをテストします。

### スキャナーの選択 {#scanner-selection}

セキュリティスキャナーは、次のいずれかによってプロジェクトに対して有効になります:

- スキャナーのCI/CDテンプレートを`.gitlab-ci.yml`ファイルに直接追加するか、AutoDevOpsを使用します。
- スキャン実行ポリシー、パイプライン実行ポリシー、またはコンプライアンスフレームワークを使用してスキャナーを強制する。この強制は、プロジェクトに直接適用することも、プロジェクトの親グループから継承することもできます。

詳細については、[セキュリティ設定](security_configuration.md)を参照してください。

### セキュリティスキャンプロセス {#security-scanning-process}

セキュリティスキャンプロセスは次のとおりです:

1. CI/CDジョブの条件に従って、有効になっており、パイプラインでの実行が意図されているスキャナーは、個別のジョブとして実行されます。

   成功した各ジョブは、1つ以上のセキュリティレポートをジョブのアーティファクトとして出力します。これらのレポートには、以前に見つかったか、無視されたか、または新しいかどうかにかかわらず、ブランチで検出されたすべての脆弱性の詳細が含まれています。
1. 各セキュリティレポートは、[検証](security_report_validation.md)や[重複排除](vulnerability_deduplication.md)などを含めて処理されます。
1. 手動ジョブを含め、すべてのジョブが完了すると、結果をダウンロードまたは表示できます。

セキュリティスキャンの出力の詳細については、[セキュリティスキャンの結果](security_scanning_results.md)を参照してください。

#### CI/CDセキュリティジョブの基準 {#cicd-security-job-criteria}

CI/CDパイプラインで実行されるセキュリティスキャンジョブは、次の基準によって決定されます:

1. セキュリティスキャンテンプレートの組み込み

   セキュリティスキャンジョブの選択は、どのテンプレートがポリシーまたはコンプライアンスフレームワークによって含まれているか、または強制されているかによって最初に決定されます。

   セキュリティスキャンは、ブランチパイプラインでデフォルトで実行されます。マージリクエストパイプラインでセキュリティスキャンを実行するには、具体的に[有効にする](security_configuration.md#use-security-scanning-tools-with-merge-request-pipelines)必要があります。

1. ルールの評価

   各テンプレートには、アナライザーを実行するかどうかを決定する定義済みの[ルール](../../../ci/yaml/_index.md#rules)があります。

   たとえば、一部のアナライザーは、特定のタイプのファイルがリポジトリで検出された場合にのみ実行されます。

1. アナライザーロジック

   テンプレートのルールでジョブを実行するように指示されている場合、テンプレートで指定されたパイプラインステージにジョブが作成されます。ただし、各アナライザーには、アナライザー自体を実行するかどうかを決定する独自のロジックがあります。

   たとえば、依存関係スキャンがデフォルトの深さでサポートされているファイルを検出しない場合、アナライザーは実行されず、アーティファクトは出力されません。

ジョブは、脆弱性が見つからなくても、スキャンを完了すると合格します。唯一の例外はカバレッジファジングであり、発見結果を特定した場合に失敗します。すべてのジョブは、パイプライン全体を失敗させないように、失敗することが許可されています。ジョブの[`allow_failure`設定](../../../ci/yaml/_index.md#allow_failure)を変更しないでください。これはパイプライン全体を失敗させるためです。

## データプライバシー {#data-privacy}

GitLabはソースコードを処理し、GitLab Runner上でローカルに分析を実行します。データはGitLabインフラストラクチャ（サーバーとrunner）の外部に送信されません。

セキュリティアナライザーは、最新の一連の署名、ルール、およびパッチをダウンロードするためにのみインターネットにアクセスします。スキャナーがインターネットにアクセスしないようにする場合は、[オフライン環境](../offline_deployments/_index.md)の使用を検討してください。
