# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module Report
      module GroupIssues
        class ErrorPatternMatcher
          ENVIRONMENT_ERROR_PATTERNS = [
            { name: "http_500_api_fabrication", pattern: /Fabrication of .+ using the API failed \(500\)/i },
            { name: "http_500_internal_server", pattern: /(500 Internal Server Error|request returned \(500\)|Expected \(200\), request returned \(500\))/i },
            { name: "http_400_backend_failing", pattern: /failed \(400\) with.+connections to all backends failing/i },
            { name: "http_503_service_unavailable", pattern: /Unexpected status code 503/i },
            { name: "pipeline_creation_timeout", pattern: /Wait for pipeline to be created failed after \d+ seconds/i },
            { name: "event_timeout", pattern: /(Timed out waiting for event|EventNotFoundError: Timed out waiting)/i },
            { name: "git_rpc_failure", pattern: /error: RPC failed; HTTP 500/i },
            { name: "repository_fabricate_error", pattern: /Repository fabricate/i }
          ].freeze

          def match(error_message)
            return nil if error_message.nil? || error_message.empty?

            ENVIRONMENT_ERROR_PATTERNS.find { |pattern_def| error_message.match?(pattern_def[:pattern]) }
          end

          def environment_error?(error_message)
            !match(error_message).nil?
          end

          def pattern_name(error_message)
            match(error_message)&.dig(:name)
          end
        end
      end
    end
  end
end
