/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.data.ExtensionInfo;
import tim.prune.data.Field;
import tim.prune.data.FileType;

public abstract class XmlHandler
extends DefaultHandler {
    private FileType _fileType = null;
    private int _fileVersion = -1;
    private final ArrayList<Field> _fieldList = new ArrayList();
    private String[] _currentValues = null;
    private static final int VERSION_UNKNOWN = -1;

    public abstract String[][] getDataArray();

    protected void addField(Field field) {
        this._fieldList.add(field);
    }

    protected boolean hasField(Field field) {
        for (Field field2 : this._fieldList) {
            if (!field2.equals(field)) continue;
            return true;
        }
        return false;
    }

    protected int getFieldIndex(Field field) {
        int n = 0;
        for (Field field2 : this._fieldList) {
            if (field2.equals(field)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final Field[] getFieldArray() {
        return this._fieldList.toArray(new Field[0]);
    }

    protected void resetCurrentValues() {
        this._currentValues = new String[this._fieldList.size()];
    }

    protected void addCurrentValue(Field field, String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        int n = this.getFieldIndex(field);
        if (this._currentValues == null || this._currentValues.length <= n) {
            String[] stringArray = new String[this._fieldList.size()];
            if (this._currentValues != null) {
                System.arraycopy(this._currentValues, 0, stringArray, 0, this._currentValues.length);
            }
            this._currentValues = stringArray;
        }
        this._currentValues[n] = string;
    }

    protected String[] getCurrentValues() {
        return this._currentValues;
    }

    public String[] getLinkArray() {
        return null;
    }

    protected void setFileType(FileType fileType) {
        this._fileType = fileType;
    }

    public FileType getFileType() {
        return this._fileType;
    }

    public void setFileVersion(String string) {
        if (string != null && string.length() == 3 && string.charAt(1) == '.') {
            try {
                this._fileVersion = 10 * Integer.parseInt(string.substring(0, 1)) + Integer.parseInt(string.substring(2, 3));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String getFileVersion() {
        if (this._fileVersion == -1) {
            return "";
        }
        return String.valueOf(this._fileVersion / 10) + "." + this._fileVersion % 10;
    }

    public abstract String getFileTitle();

    public String getFileDescription() {
        return null;
    }

    public abstract ExtensionInfo getExtensionInfo();

    protected static String getAttribute(Attributes attributes, String string) {
        String string2 = string.toLowerCase();
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string3 = attributes.getQName(n2).toLowerCase();
            if (string3.equals(string2)) {
                return attributes.getValue(n2);
            }
            ++n2;
        }
        return null;
    }
}

