/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.OperationResultPostProcessor;
import org.gradle.internal.build.event.types.AbstractTaskResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultTaskDescriptor;
import org.gradle.internal.build.event.types.DefaultTaskFailureResult;
import org.gradle.internal.build.event.types.DefaultTaskFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTaskSkippedResult;
import org.gradle.internal.build.event.types.DefaultTaskStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTaskSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.OperationDependencyLookup;
import org.gradle.tooling.internal.provider.runner.TaskOriginTracker;
import org.jspecify.annotations.Nullable;

class TaskOperationMapper
implements BuildOperationMapper<ExecuteTaskBuildOperationDetails, DefaultTaskDescriptor>,
OperationDependencyLookup {
    private final Map<TaskIdentity<?>, DefaultTaskDescriptor> descriptors = new ConcurrentHashMap();
    private final PostProcessors operationResultPostProcessor;
    private final TaskOriginTracker taskOriginTracker;
    private final OperationDependenciesResolver operationDependenciesResolver;

    TaskOperationMapper(List<OperationResultPostProcessor> operationResultPostProcessors, TaskOriginTracker taskOriginTracker, OperationDependenciesResolver operationDependenciesResolver) {
        this.operationResultPostProcessor = new PostProcessors(operationResultPostProcessors);
        this.taskOriginTracker = taskOriginTracker;
        this.operationDependenciesResolver = operationDependenciesResolver;
    }

    @Override
    public boolean isEnabled(BuildEventSubscriptions subscriptions) {
        return subscriptions.isRequested(OperationType.TASK);
    }

    @Override
    public Class<ExecuteTaskBuildOperationDetails> getDetailsType() {
        return ExecuteTaskBuildOperationDetails.class;
    }

    @Override
    public List<? extends BuildOperationTracker> getTrackers() {
        return ImmutableList.of((Object)this.taskOriginTracker, (Object)this.operationResultPostProcessor);
    }

    @Override
    public InternalOperationDescriptor lookupExistingOperationDescriptor(Node node) {
        if (node instanceof TaskNode) {
            TaskNode taskNode = (TaskNode)node;
            return (InternalOperationDescriptor)this.descriptors.get(taskNode.getTask().getTaskIdentity());
        }
        return null;
    }

    @Override
    public DefaultTaskDescriptor createDescriptor(ExecuteTaskBuildOperationDetails details, BuildOperationDescriptor buildOperation, @Nullable OperationIdentifier parent) {
        OperationIdentifier id = buildOperation.getId();
        String taskIdentityPath = buildOperation.getName();
        String displayName = buildOperation.getDisplayName();
        String taskPath = details.getTask().getIdentityPath().asString();
        Set<InternalOperationDescriptor> dependencies = this.operationDependenciesResolver.resolveDependencies((Node)details.getTaskNode());
        InternalPluginIdentifier originPlugin = this.taskOriginTracker.getOriginPlugin(details.getTask().getTaskIdentity());
        DefaultTaskDescriptor descriptor = new DefaultTaskDescriptor(id, taskIdentityPath, taskPath, displayName, parent, dependencies, originPlugin);
        DefaultTaskDescriptor descriptorWithoutDependencies = new DefaultTaskDescriptor(id, taskIdentityPath, taskPath, displayName, parent, Collections.emptySet(), originPlugin);
        this.descriptors.put(details.getTask().getTaskIdentity(), descriptorWithoutDependencies);
        return descriptor;
    }

    @Override
    public InternalOperationStartedProgressEvent createStartedEvent(DefaultTaskDescriptor descriptor, ExecuteTaskBuildOperationDetails details, OperationStartEvent startEvent) {
        return new DefaultTaskStartedProgressEvent(startEvent.getStartTime(), descriptor);
    }

    @Override
    public InternalOperationFinishedProgressEvent createFinishedEvent(DefaultTaskDescriptor descriptor, ExecuteTaskBuildOperationDetails details, OperationFinishEvent finishEvent) {
        TaskInternal task = details.getTask();
        AbstractTaskResult taskResult = this.operationResultPostProcessor.process(TaskOperationMapper.toTaskResult(task, finishEvent), task);
        return new DefaultTaskFinishedProgressEvent(finishEvent.getEndTime(), descriptor, taskResult);
    }

    private static AbstractTaskResult toTaskResult(TaskInternal task, OperationFinishEvent finishEvent) {
        boolean incremental;
        TaskStateInternal state = task.getState();
        long startTime = finishEvent.getStartTime();
        long endTime = finishEvent.getEndTime();
        ExecuteTaskBuildOperationType.Result result = (ExecuteTaskBuildOperationType.Result)finishEvent.getResult();
        boolean bl = incremental = result != null && result.isIncremental();
        if (state.getUpToDate()) {
            return new DefaultTaskSuccessResult(startTime, endTime, true, state.isFromCache(), state.getSkipMessage(), incremental, Collections.emptyList());
        }
        if (state.getSkipped()) {
            return new DefaultTaskSkippedResult(startTime, endTime, state.getSkipMessage(), incremental);
        }
        List executionReasons = result != null ? result.getUpToDateMessages() : null;
        Throwable failure = finishEvent.getFailure();
        if (failure == null) {
            return new DefaultTaskSuccessResult(startTime, endTime, false, state.isFromCache(), "SUCCESS", incremental, executionReasons);
        }
        return new DefaultTaskFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)), incremental, executionReasons);
    }

    private static class PostProcessors
    implements BuildOperationTracker {
        private final List<OperationResultPostProcessor> processors;

        public PostProcessors(List<OperationResultPostProcessor> processors) {
            this.processors = processors;
        }

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            for (OperationResultPostProcessor processor : this.processors) {
                processor.started(buildOperation, startEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            for (OperationResultPostProcessor processor : this.processors) {
                processor.finished(buildOperation, finishEvent);
            }
        }

        public AbstractTaskResult process(AbstractTaskResult taskResult, TaskInternal taskInternal) {
            for (OperationResultPostProcessor factory : this.processors) {
                taskResult = factory.process(taskResult, taskInternal);
            }
            return taskResult;
        }
    }
}

