/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.testng.collections.Lists;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.collections.Pair;

public final class ListenerOrderDeterminer {
    private static final List<String> PREFERENTIAL_PACKAGES = RuntimeBehavior.getPreferentialListeners().stream().map(each -> each.replaceAll("\\Q.*\\E", "")).collect(Collectors.toList());
    private static final Predicate<Class<?>> SHOULD_ADD_AT_END = clazz -> PREFERENTIAL_PACKAGES.stream().anyMatch(each -> clazz.getPackage().getName().contains((CharSequence)each));

    private ListenerOrderDeterminer() {
    }

    public static <T> List<T> order(Collection<T> original) {
        Pair<List<T>, List<T>> ordered = ListenerOrderDeterminer.arrange(original);
        List<T> ideListeners = ordered.first();
        List<T> regularListeners = ordered.second();
        return Lists.merge(regularListeners, ideListeners);
    }

    public static <T> List<T> reversedOrder(Collection<T> original) {
        Pair<List<T>, List<T>> ordered = ListenerOrderDeterminer.arrange(original);
        List<T> preferentialListeners = ordered.first();
        List<T> regularListeners = ordered.second();
        Collections.reverse(regularListeners);
        Collections.reverse(preferentialListeners);
        return Lists.merge(regularListeners, preferentialListeners);
    }

    private static <T> Pair<List<T>, List<T>> arrange(Collection<T> original) {
        ArrayList preferentialListeners = new ArrayList();
        ArrayList regularListeners = new ArrayList();
        original.stream().filter(Objects::nonNull).forEach(each -> {
            if (SHOULD_ADD_AT_END.test(each.getClass())) {
                preferentialListeners.add(each);
            } else {
                regularListeners.add(each);
            }
        });
        return new Pair<List<T>, List<T>>(preferentialListeners, regularListeners);
    }
}

