/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirMissingDependencySupertypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirImplicitReturnTypeAnnotationMissingDependencyChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirMissingDependencyClassProxy;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u00020\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u00020\tR\u00020\u000bj\u0006\u0010\n\u001a\u00020\tj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002R\u00020\tR\u00020\u000bj\u0006\u0010\n\u001a\u00020\tj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002R\u00020\tR\u00020\u000bj\u0006\u0010\n\u001a\u00020\tj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMissingDependencyClassForParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)V", "checkLambdaParameter", "parameter", "checkDataClassParameter", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassForParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassForParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMissingDependencyClassForParameterChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n70#2:75\n1#3:76\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassForParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMissingDependencyClassForParameterChecker\n*L\n47#1:75\n*E\n"})
public final class FirMissingDependencyClassForParameterChecker
extends FirDeclarationChecker<FirValueParameter>
implements FirMissingDependencyClassProxy {
    @NotNull
    public static final FirMissingDependencyClassForParameterChecker INSTANCE = new FirMissingDependencyClassForParameterChecker();

    private FirMissingDependencyClassForParameterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirValueParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirBasedSymbol<?> containingDeclaration = declaration.getContainingDeclarationSymbol();
        if (containingDeclaration instanceof FirAnonymousFunctionSymbol) {
            this.checkLambdaParameter(context2, reporter, declaration);
        } else if (ClassMembersKt.getCorrespondingProperty(declaration) != null) {
            boolean bl;
            FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol(containingDeclaration);
            if (firClassLikeSymbol != null) {
                FirClassLikeSymbol<?> $this$isData$iv = firClassLikeSymbol;
                boolean $i$f$isData = false;
                bl = $this$isData$iv.getRawStatus().isData();
            } else {
                bl = false;
            }
            if (bl) {
                this.checkDataClassParameter(context2, reporter, declaration);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLambdaParameter(CheckerContext context2, DiagnosticReporter reporter, FirValueParameter parameter) {
        void it;
        Name name2;
        KtSourceElement ktSourceElement = parameter.getReturnTypeRef().getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) {
            return;
        }
        Set missingTypes = new LinkedHashSet();
        this.considerType(context2, FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()), missingTypes);
        Name name3 = name2 = parameter.getName();
        Set set = missingTypes;
        KtSourceElement ktSourceElement2 = parameter.getSource();
        DiagnosticReporter diagnosticReporter = reporter;
        CheckerContext checkerContext = context2;
        FirMissingDependencyClassForParameterChecker firMissingDependencyClassForParameterChecker = this;
        boolean bl = false;
        boolean bl2 = !it.isSpecial();
        Object object = bl2 ? name2 : null;
        if (object == null) {
            Name name4 = Name.identifier((String)"_");
            object = name4;
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        }
        Name name5 = object;
        firMissingDependencyClassForParameterChecker.reportMissingTypes(checkerContext, diagnosticReporter, ktSourceElement2, set, new FirMissingDependencyClassProxy.MissingTypeOrigin.LambdaParameter(name5));
        FirImplicitReturnTypeAnnotationMissingDependencyChecker.INSTANCE.check(context2, reporter, parameter.getReturnTypeRef(), parameter.getReturnTypeRef().getSource());
    }

    private final void checkDataClassParameter(CheckerContext context2, DiagnosticReporter reporter, FirValueParameter parameter) {
        FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(context2, reporter, FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()), parameter.getSource());
    }
}

