/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.k1;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.scripting.k1.GradleScriptFileChangeListener;
import org.jetbrains.kotlin.gradle.scripting.shared.UtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.listener.ScriptChangeListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tRA\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/k1/GradleScriptListener;", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/listener/ScriptChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildRootsManager", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "getBuildRootsManager", "()Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "fileChangesProcessor", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "filePath", "", "ts", "", "getFileChangesProcessor", "()Lkotlin/jvm/functions/Function2;", "fileChanged", "isApplicable", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorActivated", "documentChanged", "kotlin.gradle.scripting.k1"})
public final class GradleScriptListener
extends ScriptChangeListener {
    public GradleScriptListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        GradleScriptFileChangeListener listener2 = new GradleScriptFileChangeListener(this, this.getBuildRootsManager());
        VirtualFileChangesListener.Companion.installAsyncVirtualFileListener((VirtualFileChangesListener)listener2, (Disposable)KotlinPluginDisposable.Companion.getInstance(project));
    }

    private final GradleBuildRootsLocator getBuildRootsManager() {
        return GradleBuildRootsLocator.Companion.getInstance(this.getProject());
    }

    @NotNull
    public final Function2<String, Long, Unit> getFileChangesProcessor() {
        GradleBuildRootsLocator buildRootsManager = this.getBuildRootsManager();
        return (arg_0, arg_1) -> GradleScriptListener._get_fileChangesProcessor_$lambda$0(buildRootsManager, arg_0, arg_1);
    }

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getFileChangesProcessor().invoke((Object)filePath, (Object)ts);
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return UtilsKt.isGradleKotlinScript(vFile);
    }

    @Override
    public void editorActivated(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.getBuildRootsManager().updateNotifications(false, (Function1<? super String, Boolean>)((Function1)arg_0 -> GradleScriptListener.editorActivated$lambda$0(vFile, arg_0)));
    }

    @Override
    public void documentChanged(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        String string = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.fileChanged(string, System.currentTimeMillis());
    }

    private static final Unit _get_fileChangesProcessor_$lambda$0(GradleBuildRootsLocator $buildRootsManager, String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        $buildRootsManager.fileChanged(filePath, ts);
        return Unit.INSTANCE;
    }

    private static final boolean editorActivated$lambda$0(VirtualFile $vFile, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$vFile.getPath());
    }
}

