/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.base.platforms.KnownLibraryKindForIndex;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmEffectiveLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindGistProvider;
import org.jetbrains.kotlin.idea.base.platforms.LibraryEffectiveKindProvider;
import org.jetbrains.kotlin.idea.base.platforms.LibraryEffectiveKindProviderKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProviderImpl;", "Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "findKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "classRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getEffectiveKind", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "nonJvmOrNull", "LibraryKindScanner", "intellij.kotlin.base.platforms"})
@SourceDebugExtension(value={"SMAP\nLibraryEffectiveKindProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryEffectiveKindProvider.kt\norg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class LibraryEffectiveKindProviderImpl
implements LibraryEffectiveKindProvider {
    @NotNull
    private final Project project;

    public LibraryEffectiveKindProviderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PersistentLibraryKind<?> findKind(VirtualFile[] classRoots) {
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])classRoots);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        virtualFile2.putUserData(LibraryEffectiveKindProviderKt.access$getCLASS_ROOTS_KEY$p(), (Object)classRoots);
        try {
            PersistentLibraryKind persistentLibraryKind = (PersistentLibraryKind)ActionsKt.runReadAction(() -> LibraryEffectiveKindProviderImpl.findKind$lambda$0(this, virtualFile2));
            return persistentLibraryKind;
        }
        finally {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)virtualFile2), (Key)LibraryEffectiveKindProviderKt.access$getCLASS_ROOTS_KEY$p());
        }
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getEffectiveKind(@NotNull Library library) {
        PersistentLibraryKind<?> persistentLibraryKind;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (!(library instanceof LibraryEx)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (((LibraryEx)library).isDisposed()) {
            return null;
        }
        PersistentLibraryKind<?> kind2 = ((LibraryEx)library).getKind();
        if (kind2 instanceof KotlinLibraryKind) {
            persistentLibraryKind = kind2;
        } else {
            PersistentLibraryKind<?> nonJvmOrNull;
            PersistentLibraryKind<?> platformKind;
            Object[] objectArray = library.getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getFiles(...)");
            Object[] classRoots = objectArray;
            VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])classRoots);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile classRoot = virtualFile;
            PersistentLibraryKind<?> persistentLibraryKind2 = (PersistentLibraryKind<?>)classRoot.getUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_KEY$p());
            if (persistentLibraryKind2 == null) {
                PersistentLibraryKind<?> persistentLibraryKind3 = this.findKind((VirtualFile[])classRoots);
                if (persistentLibraryKind3 != null) {
                    PersistentLibraryKind<?> it = persistentLibraryKind3;
                    boolean bl = false;
                    classRoot.putUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_KEY$p(), it);
                    persistentLibraryKind2 = it;
                } else {
                    persistentLibraryKind2 = null;
                }
            }
            PersistentLibraryKind<?> persistentLibraryKind4 = platformKind = persistentLibraryKind2;
            persistentLibraryKind = nonJvmOrNull = persistentLibraryKind4 != null ? this.nonJvmOrNull(persistentLibraryKind4) : null;
        }
        return persistentLibraryKind;
    }

    private final PersistentLibraryKind<?> nonJvmOrNull(PersistentLibraryKind<?> $this$nonJvmOrNull) {
        PersistentLibraryKind<?> persistentLibraryKind;
        PersistentLibraryKind<?> it = persistentLibraryKind = $this$nonJvmOrNull;
        boolean bl = false;
        return !Intrinsics.areEqual(it, (Object)KotlinJvmEffectiveLibraryKind.INSTANCE) ? persistentLibraryKind : null;
    }

    private static final PersistentLibraryKind findKind$lambda$0(LibraryEffectiveKindProviderImpl this$0, VirtualFile $virtualFile) {
        return (PersistentLibraryKind)KotlinLibraryKindGistProvider.Companion.getInstance().getKotlinLibraryKindGist().getFileData(this$0.project, $virtualFile);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProviderImpl$LibraryKindScanner;", "Lcom/intellij/util/indexing/roots/IndexableFileScanner;", "<init>", "()V", "startSession", "Lcom/intellij/util/indexing/roots/IndexableFileScanner$ScanSession;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "ScannerVisitor", "intellij.kotlin.base.platforms"})
    public static final class LibraryKindScanner
    implements IndexableFileScanner {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public IndexableFileScanner.ScanSession startSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return LibraryKindScanner::startSession$lambda$0;
        }

        private static final IndexableFileScanner.IndexableFileVisitor startSession$lambda$0(IndexableSetOrigin indexableSetOrigin) {
            Intrinsics.checkNotNullParameter((Object)indexableSetOrigin, (String)"indexableSetOrigin");
            return indexableSetOrigin instanceof LibraryOrigin ? (IndexableFileScanner.IndexableFileVisitor)new IndexableFileScanner.IndexableFileVisitor(){
                private final ScannerVisitor scannerVisitor;
                {
                    this.scannerVisitor = new ScannerVisitor();
                }

                public void visitFile(VirtualFile fileOrDir) {
                    Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                    this.scannerVisitor.visitFile(fileOrDir);
                }

                public void visitingFinished() {
                    this.scannerVisitor.visitingFinished();
                }
            } : null;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProviderImpl$LibraryKindScanner$Companion;", "", "<init>", "()V", "runScannerOutsideScanningSession", "", "classRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.kotlin.base.platforms"})
        public static final class Companion {
            private Companion() {
            }

            public final void runScannerOutsideScanningSession(@NotNull VirtualFile classRoot) {
                Intrinsics.checkNotNullParameter((Object)classRoot, (String)"classRoot");
                ScannerVisitor scannerVisitor = new ScannerVisitor();
                VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                VfsUtil.visitChildrenRecursively((VirtualFile)classRoot, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(classRoot, scannerVisitor, optionArray){
                    final /* synthetic */ VirtualFile $classRoot;
                    final /* synthetic */ ScannerVisitor $scannerVisitor;
                    {
                        this.$classRoot = $classRoot;
                        this.$scannerVisitor = $scannerVisitor;
                        super($super_call_param$1);
                    }

                    public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                        VirtualFileVisitor.Result result2;
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (this.visitFile(file)) {
                            VirtualFileVisitor.Result result3 = VirtualFileVisitor.CONTINUE;
                            result2 = result3;
                            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CONTINUE");
                        } else {
                            VirtualFileVisitor.Result result4 = VirtualFileVisitor.skipTo((VirtualFile)this.$classRoot);
                            result2 = result4;
                            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"skipTo(...)");
                        }
                        return result2;
                    }

                    public boolean visitFile(VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        ProgressManager.checkCanceled();
                        this.$scannerVisitor.visitFile(file);
                        KnownLibraryKindForIndex knownLibraryKind = this.$scannerVisitor.getKnownLibraryKindForClassRoot().get(this.$classRoot);
                        return knownLibraryKind == null || knownLibraryKind == KnownLibraryKindForIndex.COMMON;
                    }
                }));
                scannerVisitor.visitingFinished();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u001aR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProviderImpl$LibraryKindScanner$ScannerVisitor;", "", "<init>", "()V", "classFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Lorg/jetbrains/annotations/NotNull;", "getClassFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "kotlinJavaScriptMetaFileType", "getKotlinJavaScriptMetaFileType", "jarFileSystem", "Lcom/intellij/openapi/vfs/JarFileSystem;", "getJarFileSystem", "()Lcom/intellij/openapi/vfs/JarFileSystem;", "fileTypeManager", "Lcom/intellij/openapi/fileTypes/FileTypeManager;", "getFileTypeManager", "()Lcom/intellij/openapi/fileTypes/FileTypeManager;", "knownLibraryKindForClassRoot", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/base/platforms/KnownLibraryKindForIndex;", "getKnownLibraryKindForClassRoot", "()Ljava/util/concurrent/ConcurrentHashMap;", "visitFile", "", "fileOrDir", "visitingFinished", "intellij.kotlin.base.platforms"})
        private static final class ScannerVisitor {
            @NotNull
            private final FileType classFileType;
            @NotNull
            private final FileType kotlinJavaScriptMetaFileType;
            @NotNull
            private final JarFileSystem jarFileSystem;
            @NotNull
            private final FileTypeManager fileTypeManager;
            @NotNull
            private final ConcurrentHashMap<VirtualFile, KnownLibraryKindForIndex> knownLibraryKindForClassRoot;

            public ScannerVisitor() {
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension("class");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
                this.classFileType = fileType;
                FileType fileType2 = FileTypeRegistry.getInstance().getFileTypeByExtension("kjsm");
                Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByExtension(...)");
                this.kotlinJavaScriptMetaFileType = fileType2;
                JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)jarFileSystem, (String)"getInstance(...)");
                this.jarFileSystem = jarFileSystem;
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager, (String)"getInstance(...)");
                this.fileTypeManager = fileTypeManager;
                this.knownLibraryKindForClassRoot = new ConcurrentHashMap();
            }

            @NotNull
            public final FileType getClassFileType() {
                return this.classFileType;
            }

            @NotNull
            public final FileType getKotlinJavaScriptMetaFileType() {
                return this.kotlinJavaScriptMetaFileType;
            }

            @NotNull
            public final JarFileSystem getJarFileSystem() {
                return this.jarFileSystem;
            }

            @NotNull
            public final FileTypeManager getFileTypeManager() {
                return this.fileTypeManager;
            }

            @NotNull
            public final ConcurrentHashMap<VirtualFile, KnownLibraryKindForIndex> getKnownLibraryKindForClassRoot() {
                return this.knownLibraryKindForClassRoot;
            }

            public final void visitFile(@NotNull VirtualFile fileOrDir) {
                block5: {
                    FileType fileType;
                    String name2;
                    KnownLibraryKindForIndex kind2;
                    VirtualFile classRoot;
                    block7: {
                        block6: {
                            FileType fileType2;
                            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                            if (fileOrDir.isDirectory()) {
                                return;
                            }
                            VirtualFile virtualFile = this.jarFileSystem.getRootByEntry(fileOrDir);
                            if (virtualFile == null) {
                                return;
                            }
                            classRoot = virtualFile;
                            kind2 = this.knownLibraryKindForClassRoot.get(classRoot);
                            if (kind2 == KnownLibraryKindForIndex.UNKNOWN) break block5;
                            String string = fileOrDir.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            name2 = string;
                            if (StringsKt.endsWith$default((String)name2, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)".kt", (boolean)false, (int)2, null)) {
                                return;
                            }
                            if (StringsKt.endsWith$default((String)name2, (String)".class", (boolean)false, (int)2, null)) {
                                fileType2 = this.classFileType;
                            } else {
                                FileType fileTypeByExtension;
                                String extension = StringsKt.substringAfterLast((String)name2, (String)".", (String)"");
                                FileType fileType3 = this.fileTypeManager.getFileTypeByExtension(extension);
                                Intrinsics.checkNotNullExpressionValue((Object)fileType3, (String)"getFileTypeByExtension(...)");
                                fileType2 = fileTypeByExtension = fileType3;
                            }
                            fileType = fileType2;
                            if (!Intrinsics.areEqual((Object)fileType, (Object)this.classFileType)) break block6;
                            ((Map)this.knownLibraryKindForClassRoot).put(classRoot, KnownLibraryKindForIndex.UNKNOWN);
                            break block5;
                        }
                        if (!Intrinsics.areEqual((Object)fileType, (Object)this.kotlinJavaScriptMetaFileType)) break block7;
                        ((Map)this.knownLibraryKindForClassRoot).put(classRoot, KnownLibraryKindForIndex.JS);
                        break block5;
                    }
                    if (kind2 != null || !Intrinsics.areEqual((Object)fileType, (Object)KlibMetaFileType.INSTANCE) && (!StringsKt.endsWith$default((String)name2, (String)".kotlin_metadata", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInFileType.INSTANCE))) break block5;
                    ((Map)this.knownLibraryKindForClassRoot).put(classRoot, KnownLibraryKindForIndex.COMMON);
                }
            }

            public final void visitingFinished() {
                for (Map.Entry entry : ((Map)this.knownLibraryKindForClassRoot).entrySet()) {
                    VirtualFile classRoot = (VirtualFile)entry.getKey();
                    KnownLibraryKindForIndex knownLibraryKind = (KnownLibraryKindForIndex)((Object)entry.getValue());
                    classRoot.putUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_KEY$p(), null);
                    classRoot.putUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_GUESS_FROM_CONTENT_KEY$p(), (Object)knownLibraryKind);
                }
            }
        }
    }
}

